% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helpers.R
\name{get_normalized_read_counts}
\alias{get_normalized_read_counts}
\alias{get_normalized_read_counts.EZbakRFractions}
\alias{get_normalized_read_counts.EZbakRData}
\title{Get normalized read counts from either a cB table or \code{EZbakRFractions} object.}
\usage{
get_normalized_read_counts(
  obj,
  features_to_analyze,
  fractions_name = NULL,
  feature_lengths = NULL,
  scale_factors = NULL
)

\method{get_normalized_read_counts}{EZbakRFractions}(
  obj,
  features_to_analyze,
  fractions_name = NULL,
  feature_lengths = NULL,
  scale_factors = NULL
)

\method{get_normalized_read_counts}{EZbakRData}(
  obj,
  features_to_analyze,
  fractions_name = NULL,
  feature_lengths = NULL,
  scale_factors = NULL
)
}
\arguments{
\item{obj}{An \code{EZbakRData} or \code{EZbakRFractions} object.}

\item{features_to_analyze}{Features in relevant table}

\item{fractions_name}{Name of fractions table to use}

\item{feature_lengths}{Table of effective lengths for each feature combination in your
data. For example, if your analysis includes features named GF and XF, this
should be a data frame with columns GF, XF, and length.}

\item{scale_factors}{Dataframe with two columns, one being "sample" (sample names)
and the other being "scale_factor" (value to divide read counts by to normalize them)}
}
\value{
Data table of normalized read counts.
}
\description{
Uses TMM normalization strategy, similar to that used by DESeq2 and edgeR.
}
\section{Methods (by class)}{
\itemize{
\item \code{get_normalized_read_counts(EZbakRFractions)}: Method for class \strong{EZbakRFractions}
Get normalized read counts from fractions table.

\item \code{get_normalized_read_counts(EZbakRData)}: Method for class \strong{EZbakRData}
Get normalized read counts from a cB table.

}}
\examples{

# Simulate data
simdata <- EZSimulate(30)

# Create EZbakRData object
ezbdo <- EZbakRData(simdata$cB, simdata$metadf)

# Get normalized read counts
reads <- get_normalized_read_counts(ezbdo, features_to_analyze = "feature")

}
