% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EXRQ.R
\name{TwoStage}
\alias{TwoStage}
\title{Two-Stage Extreme Conditional Quantile Estimator}
\usage{
TwoStage(y, x, xstar, tau.e, k, tol = 1e-04)
}
\arguments{
\item{y}{a vector of length n representing the response}

\item{x}{a n x p matrix of n observations and p predictors}

\item{xstar}{a m x p matrix of m observations and p predictors representing
the covariate of interest}

\item{tau.e}{the extreme quantile level of interest}

\item{k}{the number of upper order statistics used in Hill estimator}

\item{tol}{the tolerance level used for checking quantile crossing}
}
\value{
A list of the following commponents is returned

Q2Stage: the estimated (extrapolated) conditional extreme quantile of the response given x=xstar at the quantile level tau.e

gamma.x: the estimated covariate-dependent extreme value index (Hill estimator associated with x=xstar)
}
\description{
This function provides the Two-Stage estimator in Wang, Li and He (2012) for conditional extreme quantiles based
on covariate-dependent extreme value index estimation. The intermediate conditional quantile is
estimated by quantile regression of the response on the original scale without any transformation.
The method is based on Hill estimator for the extreme value index and works for heavy-tailed distributions.
}
\examples{
#A simulation example (sqrt transformation, heteroscedastic error)
library(EXRQ)
n=500
tau.e = c(0.99, 0.993, 0.995)
set.seed(12368819)
x1 = runif(n, -1, 1)
x2 = runif(n, -1, 1)
sqrty = 2 + x1 + x2 + (1+0.8*x1)*rpareto(n, 0.5)
x = as.matrix(cbind(x1, x2))
y = sqrty^2
xstar = rbind(c(-0.5,0),c(0,-0.5),c(0,0),c(0.5,0),c(0,0.5))
## 2Stage method in Wang, Li and He (2012), no transformation
out.2stage <- TwoStage(y, x, xstar, tau.e, k=50)
}
\references{
Wang, H., Li, D., and He, X. (2012). Estimation of high conditional quantiles for heavytailed
distributions, Journal of the American Statistical Association, 107, 1453-1464.
}
\seealso{
\code{\link{ThreeStage}}
}

