% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uni_smap_jacobian.R
\name{uni_smap_jacobian}
\alias{uni_smap_jacobian}
\title{Univariate S-map Inferred Jacobian}
\source{
Grziwotz, F., Chang, C.-W., Dakos, V., van Nes, E.H., Schwarzländer, M., Kamps, O., et al. (2023). Anticipating the occurrence and type of critical transitions. Science Advances, 9.
}
\usage{
uni_smap_jacobian(data, theta_seq = NULL, E = 1, tau = NULL, scale = TRUE)
}
\arguments{
\item{data}{Numeric matrix with time in first column and species abundance in the second}

\item{theta_seq}{Numeric vector of thetas (nonlinear tuning parameters) to estimate the Jacobian over. If `NULL`, a default sequence is provided.}

\item{E}{Numeric. The embedding dimension. Is suggested to be positive.}

\item{tau}{Numeric. The time-delay offset to use for time delay embedding. Suggested to be positive here, but if not provided, is set to 10\% the length of the time series.}

\item{scale}{Boolean. Should data be scaled prior to estimating the Jacobian.}
}
\value{
A list containing three objects:
\item{smap_J}{Jacobian matrices across taus. It is recommended to average across these matrices.}
\item{eigenJ}{Absolute maximum eigenvalue.}
\item{reJ}{Real component of dominant eigenvalue}
\item{imJ}{Imaginary component of dominant eigenvalue.}
}
\description{
Performs the S-map on a univariate time series to infer the Jacobian matrix at different points in time across thetas.
}
\examples{
#Load the multivariate simulated
#dataset `simTransComms`

data("simTransComms")

#Subset the second community prior to the transition

pre_simTransComms <- subset(simTransComms$community2,time < inflection_pt)
winsize <- round(dim(pre_simTransComms)[1] * 50/100)

#Estimate the Jacobian for the first 50 timepoints of the
#second species using s-map
est_jac <- uni_smap_jacobian(pre_simTransComms[1:50,2:3])

}
