% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniAR.R
\name{uniAR}
\alias{uniAR}
\title{Univariate Jacobian Index Estimated From Univariate Autocorrelation Matrix}
\usage{
uniAR(data, scale = TRUE, winsize = 50, p = 1, dt = 1)
}
\arguments{
\item{data}{Numeric matrix with time in first column and species abundance in the second}

\item{scale}{Boolean. Should data be scaled prior to estimating the Jacobian.}

\item{winsize}{Numeric. Defines the window size of the rolling window as a percentage of the time series length.}

\item{p}{Numeric. Defines the model order. Defaults to `1`.}

\item{dt}{Numeric An appropriate time step}
}
\value{
A dataframe where the first column is last time index of the window and the second column is the estimated index value. A value <1.0 indicates stability, a value >1.0 indicates instability.
}
\description{
Estimate the dominant Jacobian eigenvalue of a univariate time series using autocorrelated stochastic differential equations
}
\examples{
#Load the multivariate simulated
#dataset `simTransComms`

data(simTransComms)

#Subset the second community prior to the transition

pre_simTransComms <- subset(simTransComms$community2,time < inflection_pt)

#Estimate the univariate stability index for the first species in
#the second community

egarJ <- uniAR(data = pre_simTransComms[,2:3],
winsize = 25, dt = 1)

}
