% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETDQualitizer.R
\name{ScreenConfiguration}
\alias{ScreenConfiguration}
\title{R6 Screen Configuration Class}
\description{
Provides methods for converting between pixel, millimeter, and degree units.
}
\examples{
sc <- ScreenConfiguration$new(500, 300, 1920, 1080, 600)
sc$pix_to_deg(960, 540)

## ------------------------------------------------
## Method `ScreenConfiguration$new`
## ------------------------------------------------

sc <- ScreenConfiguration$new(500, 300, 1920, 1080, 600)

## ------------------------------------------------
## Method `ScreenConfiguration$pix_to_mm`
## ------------------------------------------------

sc$pix_to_mm(960, 540)

## ------------------------------------------------
## Method `ScreenConfiguration$pix_to_deg`
## ------------------------------------------------

sc$pix_to_deg(960, 540)

## ------------------------------------------------
## Method `ScreenConfiguration$mm_to_deg`
## ------------------------------------------------

sc$mm_to_deg(100, 50)

## ------------------------------------------------
## Method `ScreenConfiguration$mm_to_pix`
## ------------------------------------------------

sc$mm_to_pix(100, 50)

## ------------------------------------------------
## Method `ScreenConfiguration$deg_to_mm`
## ------------------------------------------------

sc$deg_to_mm(2, 1)

## ------------------------------------------------
## Method `ScreenConfiguration$deg_to_pix`
## ------------------------------------------------

sc$deg_to_pix(2, 1)

## ------------------------------------------------
## Method `ScreenConfiguration$screen_extents`
## ------------------------------------------------

sc$screen_extents()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{screen_size_x_mm}}{Screen width in mm.}

\item{\code{screen_size_y_mm}}{Screen height in mm.}

\item{\code{screen_res_x_pix}}{Horizontal screen resolution in pixels.}

\item{\code{screen_res_y_pix}}{Vertical screen resolution in pixels.}

\item{\code{viewing_distance_mm}}{Viewing distance in mm.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ScreenConfiguration-new}{\code{ScreenConfiguration$new()}}
\item \href{#method-ScreenConfiguration-pix_to_mm}{\code{ScreenConfiguration$pix_to_mm()}}
\item \href{#method-ScreenConfiguration-pix_to_deg}{\code{ScreenConfiguration$pix_to_deg()}}
\item \href{#method-ScreenConfiguration-mm_to_deg}{\code{ScreenConfiguration$mm_to_deg()}}
\item \href{#method-ScreenConfiguration-mm_to_pix}{\code{ScreenConfiguration$mm_to_pix()}}
\item \href{#method-ScreenConfiguration-deg_to_mm}{\code{ScreenConfiguration$deg_to_mm()}}
\item \href{#method-ScreenConfiguration-deg_to_pix}{\code{ScreenConfiguration$deg_to_pix()}}
\item \href{#method-ScreenConfiguration-screen_extents}{\code{ScreenConfiguration$screen_extents()}}
\item \href{#method-ScreenConfiguration-clone}{\code{ScreenConfiguration$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-new"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-new}{}}}
\subsection{Method \code{new()}}{
Creates a new ScreenConfiguration object with screen and viewing distance parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$new(
  screen_size_x_mm,
  screen_size_y_mm,
  screen_res_x_pix,
  screen_res_y_pix,
  viewing_distance_mm
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{screen_size_x_mm}}{Screen width in millimeters.}

\item{\code{screen_size_y_mm}}{Screen height in millimeters.}

\item{\code{screen_res_x_pix}}{Horizontal screen resolution in pixels.}

\item{\code{screen_res_y_pix}}{Vertical screen resolution in pixels.}

\item{\code{viewing_distance_mm}}{Viewing distance in millimeters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new ScreenConfiguration object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sc <- ScreenConfiguration$new(500, 300, 1920, 1080, 600)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-pix_to_mm"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-pix_to_mm}{}}}
\subsection{Method \code{pix_to_mm()}}{
Converts pixel coordinates to millimeter coordinates on the screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$pix_to_mm(x, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Horizontal pixel coordinate.}

\item{\code{y}}{Vertical pixel coordinate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with x and y in millimeters.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sc$pix_to_mm(960, 540)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-pix_to_deg"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-pix_to_deg}{}}}
\subsection{Method \code{pix_to_deg()}}{
Converts pixel coordinates to an angular gaze direction in degrees.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$pix_to_deg(x, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Horizontal pixel coordinate.}

\item{\code{y}}{Vertical pixel coordinate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with azimuth (\code{"azi"}) and elevation (\code{"ele"}) in degrees.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sc$pix_to_deg(960, 540)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-mm_to_deg"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-mm_to_deg}{}}}
\subsection{Method \code{mm_to_deg()}}{
Converts millimeter coordinates to an angular gaze direction in degrees.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$mm_to_deg(x, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Horizontal position in millimeters.}

\item{\code{y}}{Vertical position in millimeters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with azimuth (\code{"azi"}) and elevation (\code{"ele"}) in degrees.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sc$mm_to_deg(100, 50)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-mm_to_pix"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-mm_to_pix}{}}}
\subsection{Method \code{mm_to_pix()}}{
Converts millimeter coordinates on the screen to pixel coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$mm_to_pix(x, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Horizontal position in millimeters.}

\item{\code{y}}{Vertical position in millimeters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with x and y in pixels.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sc$mm_to_pix(100, 50)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-deg_to_mm"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-deg_to_mm}{}}}
\subsection{Method \code{deg_to_mm()}}{
Converts an angular gaze direction in degrees to millimeter coordinates on the screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$deg_to_mm(azi, ele)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{azi}}{Azimuth in degrees (Fick angles).}

\item{\code{ele}}{Elevation in degrees (Fick angles).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with x and y in millimeters.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sc$deg_to_mm(2, 1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-deg_to_pix"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-deg_to_pix}{}}}
\subsection{Method \code{deg_to_pix()}}{
Converts an angular gaze direction in degrees to pixel coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$deg_to_pix(azi, ele)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{azi}}{Azimuth in degrees (Fick angles).}

\item{\code{ele}}{Elevation in degrees (Fick angles).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with x and y in pixels.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sc$deg_to_pix(2, 1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-screen_extents"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-screen_extents}{}}}
\subsection{Method \code{screen_extents()}}{
Computes the horizontal and vertical extents of the screen (in degrees).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$screen_extents()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with width and height in degrees.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sc$screen_extents()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScreenConfiguration-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ScreenConfiguration-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScreenConfiguration$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
