% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammacp.R
\name{gammacp}
\alias{gammacp}
\title{Probabilistic estimation of earthquake recurrence interval using gamma distribution}
\usage{
gammacp(fit, r, te)
}
\arguments{
\item{fit}{Fit is the fitgamma object. See ?fitgamma for details.}

\item{r}{The specified time in which the probability of an earthquake is desired to be calculated.}

\item{te}{Elapsed time since the last earthquake}
}
\value{
A numeric value
}
\description{
Computes the probability of an earthquake within a specified time "r" and elapsed time "te".
}
\examples{
fit=fitgamma(c(1,1),data=data_earthquake_6_6.5)
gammacp(fit,r=2,te=5)
}
\references{
Pasari, S. and Dikshit, O. (2014). Impact of three-parameter Weibull models in probabilistic assessment of earthquake hazards. Pure and Applied Geophysics, 171, 1251-1281.
}
