% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSS.R
\name{vcov.EMSS}
\alias{vcov.EMSS}
\title{Getting Variance-Covariance Matrix for Parameters of EM type Sample Selection Model Fits}
\usage{
\method{vcov}{EMSS}(object, ...)
}
\arguments{
\item{object}{an object of class "EMSS" made by the function \code{EMSS}.}

\item{...}{not used, but exists because of the compatibility.}
}
\description{
\code{vcov} method for a class "EMSS".
}
\examples{
# examples continued from EMSS
data(Smoke, package = "EMSS")
ex1 <- EMSS(response = cigs_intervals ~ educ,
           selection = smoker ~ educ + age,
           data = Smoke)
vcov(ex1)

data(Smoke, package = "EMSS")
ex2 <- EMSS(response = cigs_intervals ~ educ,
           selection =  smoker ~ educ + age,
           data = Smoke, method="ECMnr")
vcov(ex2)

## example using random numbers with exclusion restriction

N <- 1000
errps <- mvtnorm::rmvnorm(N,c(0,0),matrix(c(1,0.5,0.5,1),2,2) )
xs <- runif(N)
ys <- xs+errps[,1]>0
xo <- runif(N)
yo <- (xo+errps[,2])*(ys>0)

ex3 <- EMSS(response = yo ~ xo,
           selection = ys ~ xs,
           initial.param = c(rep(0,4), 0.3, 0.6), method="ECMnr")
vcov(ex3)

}
