% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSC.R
\name{EMSC}
\alias{EMSC}
\title{Extended multiplicative signal correction (EMSC)}
\usage{
EMSC(X, model = NULL, ...)
}
\arguments{
\item{X}{\code{matrix} containing spectra as rows.}

\item{model}{an EMSC model to use instead of the other parameters.}

\item{...}{named model parameters for EMSC_model.}
}
\value{
An object of class EMSC is returned. This contains:
\itemize{
 \item \code{corrected}: \code{matrix} of corrected spectra.
 \item \code{parameters}: \code{matrix} of fitted parameter values.
 \item \code{model}: object containing input all input parameters.
 \item \code{X}: original data.
}
}
\description{
Performs model-based background correction and normalisation of spectra. EMSC handles
variations in scaling, polynomial baselines and interferents. Parameters for corrections
are stored for further analysis, and spectra are corrected accordingly.
}
\details{
This is the main EMSC function performing all calculations. It can be run with
no parameters (defaults are used), with a predefined EMSC model object or with
parameters that are passed on to the EMSC model building function \code{\link{EMSC_model}}.
}
\examples{
data(fishoil)
Raman      <- fishoil$Raman[, 850:3300]
EMSC.basic <- EMSC(Raman)
EMSC.poly6 <- EMSC(Raman, degree = 6)
EMSC.rep   <- EMSC(Raman, degree = 6, reference = Raman[30, ],
                   replicates = fishoil$replicates)

old.par  <- par(mfrow = c(2,2), mar = c(4,4,1,1))
xlim     <- rev(as.numeric(range(colnames(Raman))))
matplot(colnames(Raman), t(Raman), type = 'l', xlim = xlim,
        ylab = 'Relative intensity', xlab = 'Raw spectra')
matplot(colnames(Raman), t(EMSC.basic$corrected), type = 'l', xlim = xlim,
        ylab = 'Relative intensity', xlab = 'Corrected (basic)')
matplot(colnames(Raman), t(EMSC.poly6$corrected), type = 'l', xlim = xlim,
        ylab = 'Relative intensity', xlab = 'Corrected (6th degree polynomial)')
matplot(colnames(Raman), t(EMSC.rep$corrected),   type = 'l', xlim = xlim,
        ylab = 'Relative intensity', 
        xlab = 'Corrected (reference = spec. #30, replicate correction (90\%))')
par(old.par)

}
\references{
H. Martens, E. Stark, Extended multiplicative signal correction and spectral
 interference subtraction: new preprocessing methods for near infrared spectroscopy.
 J Pharm Biomed Anal. 1991; 9(8):625-35.

Joakim Skogholt, Kristian Hovde Liland, Ulf Geir Indahl,
 Pre-processing of spectral data in the extended multiplicative signal correction framework using multiple reference spectra
 Journal of Raman Spectroscopy 50(3), (2019), pp. 407-417.
}
\seealso{
\code{\link{EMSC_model}} \code{\link{predict.EMSC}} \code{\link{plot.EMSC}}
}
