% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeAnnualSeries.R
\name{makeAnnualSeries}
\alias{makeAnnualSeries}
\title{Produces annual series of 8 streamflow statistics (and a lowess smooth of them) from daily streamflow data}
\usage{
makeAnnualSeries(eList, edgeAdjust = TRUE)
}
\arguments{
\item{eList}{named list with at least Daily and INFO dataframes}

\item{edgeAdjust}{logical specifying whether to use the modified method for 
calculating the windows at the edge of the record.  The modified method tends to 
reduce curvature near the start and end of record.  
Default is TRUE, but a logical in INFO$edgeAdjust will override the default.}
}
\value{
annualSeries matrix that contains the annual series of streamflow statistics
annualSeries is a matrix 3 * 8 * numYears, where numYears is the number of years in the data set
in the first dimension 1 is the year, 2 is the actual value, 3 is the smoothed value
in the second dimension, the index is the istat value (identifying the flow statistic)
the third dimension is year
}
\description{
Part of the flowHistory system.  The data come from Daily and INFO data frames. 
Note that the function setPA must be run before this to establish the period of analysis (e.g. water year).
}
\details{
\tabular{ll}{
istat  \tab Name  \cr
1 \tab minimum 1-day daily mean discharge \cr 
2 \tab minimum 7-day mean of the daily mean discharges \cr 
3 \tab minimum 30-day mean of the daily mean discharges \cr 
4 \tab median of the daily mean discharges \cr 
5 \tab mean of the daily mean discharges \cr 
6 \tab maximum 30-day mean of the daily mean discharges \cr 
7 \tab maximum 7-day mean of the daily mean discharges \cr 
8 \tab  maximum 1-day daily mean discharge \cr  
}


The smooth is a loess smooth computed on the log flow values and then transformed back to real space
Smoothing window is a fixed number of years, the window width has a default value of 20 years but can be modified by changing its value in INFO data frame (using setPA function)
}
\examples{
eList <- Choptank_eList
annualSeries <- makeAnnualSeries(eList)
}
\keyword{statistics}
\keyword{streamflow}
\keyword{trends}
