\name{schwefel_12}
\alias{schwefel_12}
\title{Schwefel 1.2 function for optimization problems}

\usage{
schwefel_12(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Schwefel 1.2 function is evaluated.
  }
}

\value{
Returns a numeric value representing the evaluation of the Schwefel 1.2 function at the input vector \code{x}.
}

\description{
The Schwefel 1.2 function is a commonly used benchmark function in optimization problems. It is non-convex and has a global minimum at the origin. The function is characterized by a cumulative sum of squared terms, making it challenging for optimization algorithms.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
schwefel_12(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
schwefel_12(x)

# Contour Plot: Visualizing the Schwefel 1.2 Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) schwefel_12(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Schwefel 1.2 Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = schwefel_12, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) schwefel_12(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Schwefel 1.2 Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
{Schwefel, H.-P. (1981). \emph{Numerical Optimization of Computer Models}. Wiley.}
}
