% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BootstrapES.R
\name{BootstrapES}
\alias{BootstrapES}
\title{Bootstrapped ES for specified confidence level}
\usage{
BootstrapES(Ra, number.resamples, cl)
}
\arguments{
\item{Ra}{Vector corresponding to profit and loss distribution}

\item{number.resamples}{Number of samples to be taken in bootstrap procedure}

\item{cl}{Number corresponding to Expected Shortfall confidence level}
}
\value{
Bootstrapped Expected Shortfall
}
\description{
Estimates the bootstrapped ES for confidence level and holding period
implied by data frequency.
}
\examples{
# Estimates bootstrapped ES for given parameters
   a <- rnorm(100) # generate a random profit/loss vector
   BootstrapVaR(a, 50, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

