% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{Beta}
\alias{Beta}
\alias{expValBeta}
\alias{varBeta}
\alias{kthMomentBeta}
\alias{expValLimBeta}
\alias{expValTruncBeta}
\alias{stopLossBeta}
\alias{meanExcessBeta}
\alias{VatRBeta}
\alias{TVatRBeta}
\alias{mgfBeta}
\title{Beta Distribution}
\usage{
expValBeta(shape1, shape2)

varBeta(shape1, shape2)

kthMomentBeta(k, shape1, shape2)

expValLimBeta(d, shape1, shape2)

expValTruncBeta(d, shape1, shape2, less.than.d = TRUE)

stopLossBeta(d, shape1, shape2)

meanExcessBeta(d, shape1, shape2)

VatRBeta(kap, shape1, shape2)

TVatRBeta(kap, shape1, shape2)

mgfBeta(t, shape1, shape2, k0)
}
\arguments{
\item{shape1}{shape parameter \eqn{\alpha}{alpha}, must be positive.}

\item{shape2}{shape parameter \eqn{\beta}{beta}, must be positive.}

\item{k}{kth-moment.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}

\item{t}{t.}

\item{k0}{point up to which to sum the distribution for the approximation.}
}
\value{
Function :
  \itemize{
    \item \code{\link{expValBeta}}  gives the expected value.
    \item \code{\link{varBeta}}  gives the variance.
    \item \code{\link{kthMomentBeta}}  gives the kth moment.
    \item \code{\link{expValLimBeta}}  gives the limited mean.
    \item \code{\link{expValTruncBeta}}  gives the truncated mean.
    \item \code{\link{stopLossBeta}}  gives the stop-loss.
    \item \code{\link{meanExcessBeta}}  gives the mean excess loss.
    \item \code{\link{VatRBeta}}  gives the Value-at-Risk.
    \item \code{\link{TVatRBeta}}  gives the Tail Value-at-Risk.
    \item \code{\link{mgfBeta}}  gives the moment generating function (MGF).
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Beta distribution with shape parameters \eqn{\alpha}{alpha} and \eqn{\beta}{beta}.
}
\details{
The Beta distribution with shape parameters \eqn{\alpha}{a} and
\eqn{\beta}{b} has density:
  \deqn{f\left(x\right) = \frac{\Gamma(\alpha + \beta)}{\Gamma(\alpha) %
  \Gamma(\beta)} x^{\alpha - 1} (1 - x)^(\beta - 1)}{f(x) = Γ(a+b) / %
  (Γ(a)Γ(b))x^(a - 1)(1 - x)^(b - 1)}
for \eqn{x \in [0, 1]}{0 ≤ x ≤ 1}, \eqn{\alpha, \beta > 0}{a, b > 0}.
}
\note{
Function VatRBeta is a wrapper for the \code{\link[stats]{qbeta}}
function from the stats package.
}
\examples{
expValBeta(shape1 = 3, shape2 = 5)

varBeta(shape1 = 4, shape2 = 5)

kthMomentBeta(k = 3, shape1 = 4, shape2 = 5)

expValLimBeta(d = 0.3, shape1 = 4, shape2 = 5)

expValTruncBeta(d = 0.4, shape1 = 4, shape2 = 5)

# Values less than d
expValTruncBeta(d = 0.4, shape1 = 4, shape2 = 5, less.than.d = FALSE)

stopLossBeta(d = 0.3, shape1 = 4, shape2 = 5)

meanExcessBeta(d = .3, shape1 = 4, shape2 = 5)

VatRBeta(kap = .99, shape1 = 4, shape2 = 5)

TVatRBeta(kap = .99, shape1 = 4, shape2 = 5)

mgfBeta(t = 1, shape1 = 3, shape2 = 5, k0 = 1E2)

}
