% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/V_Payment_Protection.R
\name{V_Payment_Protection}
\alias{V_Payment_Protection}
\title{Reserve valuation for Payment Protection}
\usage{
V_Payment_Protection(
  px,
  x,
  n,
  k = 1,
  cantprem = 1,
  premperyear = 1,
  i = 0.04,
  ip = 0.04,
  data,
  prop = 1,
  type = "outstanding_debt",
  method = "interest_only",
  V0,
  t
)
}
\arguments{
\item{px}{A numeric value. The value of the premium paid in each period.}

\item{x}{An integer. The age of the insuree.}

\item{n}{An integer. Loan term (in years).}

\item{k}{An integer. Number of payments per year.}

\item{cantprem}{An integer. The total number of premiums.}

\item{premperyear}{An integer. The number of premiums to be paid per year.}

\item{i}{The interest rate. A numeric type value.}

\item{ip}{The interest rate of the loan. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table used (between 0 and 1).}

\item{type}{A character string. The type of loan protection/reimburstment ("outstanding_debt" or "payments").}

\item{method}{A character string. Amortization scheme ("constant_instalment", "interest_only" or "constant_principal").}

\item{V0}{A numeric type value. Loan value.}

\item{t}{An integer. The moment of valuation (in months if it is a fractional coverage or in years if it is not).}
}
\value{
Returns the actuarial present value of the loan protection.
}
\description{
Calculates the reserve for the loan insurance up to the moment t.
}
\examples{
px1<-31.6216618772779
c1<-10500
V_Payment_Protection(px1,30,25,1,10,1,0.06,0.07,CSO80FANB,1,"payments","constant_instalment",c1,25)

}
\keyword{Payment}
\keyword{Protection}
