% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Am..R
\name{Am.}
\alias{Am.}
\title{Life Insurance of a group}
\usage{
Am.(
  x,
  h,
  n,
  k = 1,
  i = 0.04,
  data,
  prop = 1,
  ndeath = 1,
  assumption = "none",
  cap = 1
)
}
\arguments{
\item{x}{A vector of intergers representing the age of each individual of the group.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Number of fractions per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{ndeath}{An integer. Number of deaths necessary for payment to occur.}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{cap}{A numeric type value. The value of the payment.}
}
\value{
Returns a numeric value (actuarial present value).
}
\description{
Calculates the present value of a life insurance coverage for a group.
}
\examples{
ages<-c(22,33,44,55,66)
Am.(ages,5,15,1,0.04,CSO80MANB,1,2,"none",1)
Am.(ages,0,20,4,0.04,CSO80MANB,1,2,"UDD",1)
Am.(ages,10,25,2,0.04,CSO80MANB,1,2,"constant",1)

}
\keyword{Group}
\keyword{Insurance}
\keyword{Life}
