% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{mhyper}
\alias{mhyper}
\title{Mean and Variance of the Hypergeometric Distribution}
\usage{
mhyper(m, n, k)
}
\arguments{
\item{m}{Number of successes in the population}

\item{n}{Number of failures in the population}

\item{k}{Sample size}
}
\value{
List with mean and variance
}
\description{
Formula:
\eqn{\mu = k \cdot \frac{m}{m + n}}
\eqn{\mathrm{Var}(X) = k \cdot \frac{m}{m + n} \cdot \frac{n}{m + n} \cdot \frac{m + n - k}{m + n - 1}}
}
\examples{
mhyper(m = 20, n = 30, k = 10)
}
\seealso{
\code{\link[stats]{dhyper}}
}
