% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.R
\name{delta}
\alias{delta}
\alias{Delta}
\title{Compute the Delta coefficient}
\usage{
delta(
  data,
  standard = FALSE,
  fixedRows = FALSE,
  rawdata = NULL,
  tol = 1e-07,
  mxits = 100
)

Delta(
  data,
  standard = FALSE,
  fixedRows = FALSE,
  rawdata = NULL,
  tol = 1e-07,
  mxits = 100
)
}
\arguments{
\item{data}{either a contingency table or raw data.}

\item{standard}{a logical value indicating whether the observer on the rows of the contingency table (or first column of raw data) is a goldstandard (i.e., gives the correct responses).}

\item{fixedRows}{a logical value indicating whether the row marginals are fixed in advance (sampling type II) or not (sampling type I).}

\item{rawdata}{a logical value indicating whether the data is raw (TRUE) or a contingency table (FALSE). If not specified, the function will try to guess the data type.}

\item{tol}{the desired tolerance applied to find the root of the unknown constant B, needed to estimate the model parameters.}

\item{mxits}{the maximum numer of iterations applied to find the root of the unknown constant B, needed to estimate the model parameters.}
}
\value{
An object of class \code{"delta"}, which is a list of 9 elements (or 10 if the dimension of the contingency table is 2x2). See details.
}
\description{
\code{delta()} computes Delta coefficient, or proportion of agreements that are not due to chance,
which is used to measure nominal agreement between two raters.

\code{delta()} and \code{Delta()} are synonyms.
}
\details{
The allowed input data type are (1) contingency tables (of class \code{"table"} or \code{"matrix"}) or (2) raw data (of class \code{"data.frame"}).
If the data is of type (1), the empty classes (if any) are removed. If the data is of class (2), the function checks the number of columns (n) and throws an
error if n < 2 or n > 3. If n = 2, a frequency table is computed. If n = 3, it is assumed that one column represents the row index (normally, it is expected to be the first one).
Once the row index column is identified, it is removed and a frequency table is computed using the remaining two columns.
In all cases, the result is always a squared matrix, which will be used in the subsequent computation of the Delta coefficient.
The observer on the rows will be referred to as observer (or rater) R and the one on the columns will be referred to as observer (or rater) C.

The function returns a list of 9 elements (if the number of classes is >2):
\itemize{
\item Delta: This is a list of 2 elements:
(1) the estimates of the model: overall delta (Delta), partial delta for class j (partial_delta) and the distribution of responses made at random by observer C (proportions);
and the agreement measurements: agreement, conformity, predictivity and consistency (only some of the are shown, depending on the model assumed)
(2) the standard error of the estimates under the model assumed (sampling type I or II).
\item Kappa: The estimate and standard error of the Cohen's Kappa coffiecient.
\item Data: Input data and analyzed data (may be the same)
\item GOF: Goodness of Fit for the Delta model. The chi squares statistic is computed. If the performed test is significative (p-value < alpha), the model Delta is not suitable for the data.
\item fixedRows: logical value that matches the "fixedRows" argument.
\item standard: logical value that matches the "standard" argument.
\item all.measures: This is a list including all the estimates and standard errors (disregarding the model assumed by the user).
\item problem.parameters: This list contains information about the estimation of the auxiliary constant B, needed to estimate the model parameters.
\item cov: This list contains 3 elements: the covariance matrix of the partial delta estimates; the covariance matrix of the proportion estimates; and the covariance matrix of the partial delta and proportion estimates.
}

If the number of classes is k = 2, another element is added to the aforementioned list, including the asymptotic analysis (asymptoticDelta).
}
\examples{
# Create a 3x3 matrix
m = matrix(c(15, 5, 0, 4, 21, 1, 3, 4, 25), ncol = 3)
# Compute the Delta coefficient assuming the rater on the rows 
# is a goldstandard and type II sampling.
obj = delta(m, standard = TRUE, fixedRows = TRUE)
# Get the complete report
summary(obj, fullReport = TRUE)

# Create a 2x2 matrix
m = matrix(c(15, 7, 3, 21), ncol = 2)
# Compute the Delta coefficient assuming no one is a goldstandard 
# and type I sampling.
obj = delta(m, standard = FALSE, fixedRows = FALSE)
# Get the report
summary(obj, fullReport = FALSE)

}
\references{
Andrés, A. M., & Marzo, P. F. (2004). Delta: A new measure of agreement between two raters. British journal of mathematical and statistical psychology, 57(1), 1-19.

Andrés, A. M., & Marzo, P. F. (2005). Chance-corrected measures of reliability and validity in KK tables. Statistical methods in medical research, 14(5), 473-492.
}
\seealso{
\code{\link[=summary.delta]{summary.delta()}} for the summary method created for objects of class delta, and \code{\link[=print.deltaMAN]{print.deltaMAN()}} for the print method.
}
