/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.SetRecodingsDialog;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.VariableSelector;

public class RecodeDialog
extends JDialog
implements ActionListener {
    private SetRecodingsDialog codes;
    private VariableSelector variableSelector;
    private JList recodeVariableList;
    private JButton intoButton;
    private IconButton removeButton;
    private JButton cancelButton;
    private JButton runButton;
    private JButton defineButton;
    private IconButton addButton;
    private HelpButton help;
    private static DefaultListModel lastListModel;
    private static String lastDataName;

    public RecodeDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Recode Variables");
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("pmwiki.php?n=Main.RecodeVariables");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(867, 934, 968, 21, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.removeButton = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add((Component)this.removeButton, new AnchorConstraint(530, 425, 680, 350, 1, 1, 1, 1));
            this.removeButton.setPreferredSize(new Dimension(41, 40));
            this.cancelButton = new JButton();
            this.getContentPane().add((Component)this.cancelButton, new AnchorConstraint(767, 934, 835, 801, 1, 1, 1, 1));
            this.cancelButton.setText("Cancel");
            this.cancelButton.setPreferredSize(new Dimension(84, 23));
            this.cancelButton.addActionListener(this);
            this.runButton = new JButton();
            this.getContentPane().add((Component)this.runButton, new AnchorConstraint(867, 934, 968, 801, 1, 1, 1, 1));
            this.runButton.setText("OK");
            this.runButton.setPreferredSize(new Dimension(84, 34));
            this.runButton.addActionListener(this);
            this.defineButton = new JButton();
            this.getContentPane().add((Component)this.defineButton, new AnchorConstraint(870, 728, 965, 496, 1, 1, 1, 1));
            this.defineButton.setText("Define Recode");
            this.defineButton.setPreferredSize(new Dimension(147, 32));
            this.defineButton.addActionListener(this);
            this.addButton = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add((Component)this.addButton, new AnchorConstraint(375, 425, 525, 350, 1, 1, 1, 1));
            this.addButton.setPreferredSize(new Dimension(41, 40));
            this.intoButton = new JButton();
            this.getContentPane().add((Component)this.intoButton, new AnchorConstraint(218, 934, 295, 782, 1, 1, 1, 1));
            this.intoButton.setText("\u2192 Target");
            this.intoButton.setPreferredSize(new Dimension(96, 26));
            this.intoButton.setFont(new Font("Tahoma", 0, 10));
            this.intoButton.addActionListener(this);
            JPanel jPanel = new JPanel();
            Object object = new BorderLayout();
            jPanel.setLayout((LayoutManager)object);
            this.recodeVariableList = new RecodeDJList();
            JScrollPane jScrollPane = new JScrollPane(this.recodeVariableList, 22, 31);
            jPanel.add(jScrollPane);
            this.getContentPane().add((Component)jPanel, new AnchorConstraint(123, 758, 835, 467, 1, 1, 1, 1));
            this.recodeVariableList.setModel(new DefaultListModel());
            jPanel.setPreferredSize(new Dimension(184, 240));
            jPanel.setBorder(BorderFactory.createTitledBorder("Variables to Recode"));
            this.variableSelector = new VariableSelector();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(72, 325, 835, 21, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(192, 301));
            this.variableSelector.setBorder(BorderFactory.createEtchedBorder(1));
            this.variableSelector.getJComboBox().addActionListener(this);
            this.variableSelector.setDropStringSplitter("\u2192");
            if (lastDataName != null) {
                this.variableSelector.setSelectedData(lastDataName);
            }
            if (lastListModel != null && lastDataName != null) {
                this.recodeVariableList.setModel(lastListModel);
                for (int i = 0; i < lastListModel.getSize(); ++i) {
                    object = (String)lastListModel.get(i);
                    boolean bl = this.variableSelector.remove(object = ((String)object).substring(0, ((String)object).indexOf("\u2192")));
                    if (bl) continue;
                    this.recodeVariableList.setModel(new DefaultListModel());
                    JList jList = this.variableSelector.getJList();
                    VariableSelector variableSelector = this.variableSelector;
                    Objects.requireNonNull(variableSelector);
                    jList.setModel(new VariableSelector.FilteringModel(variableSelector, Deducer.timedEval("names(" + this.variableSelector.getJComboBox().getSelectedItem() + ")").asStrings()));
                    break;
                }
            }
            this.setMinimumSize(new Dimension(450, 250));
            this.setSize(640, 371);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "Add") {
            JList jList = this.variableSelector.getJList();
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                String string2 = (String)objectArray[i];
                ((DefaultListModel)this.recodeVariableList.getModel()).addElement(string2.concat("\u2192".concat(string2)));
                this.variableSelector.remove(objectArray[i]);
            }
        } else if (string == "Remove") {
            Object[] objectArray = this.recodeVariableList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                String string3 = (String)objectArray[i];
                ((DefaultListModel)this.recodeVariableList.getModel()).removeElement(objectArray[i]);
                this.variableSelector.add(string3.substring(0, string3.indexOf("\u2192")));
            }
        } else if (string == "\u2192 Target") {
            int n = this.recodeVariableList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            String string4 = (String)this.recodeVariableList.getSelectedValue();
            string4 = string4.substring(0, string4.indexOf("\u2192"));
            String string5 = JOptionPane.showInputDialog(this, (Object)("Recode " + string4 + " into:"));
            if (string5 == null || string5 == "") {
                return;
            }
            string5 = RController.makeValidVariableName((String)string5);
            ((DefaultListModel)this.recodeVariableList.getModel()).removeElementAt(n);
            ((DefaultListModel)this.recodeVariableList.getModel()).addElement(string4 + "\u2192" + string5);
        } else if (string == "Define Recode") {
            String[] stringArray = new String[this.recodeVariableList.getModel().getSize()];
            for (int i = 0; i < this.recodeVariableList.getModel().getSize(); ++i) {
                stringArray[i] = (String)this.recodeVariableList.getModel().getElementAt(i);
            }
            this.codes = new SetRecodingsDialog(this, stringArray, (String)this.variableSelector.getJComboBox().getSelectedItem());
            this.codes.setLocationRelativeTo(this);
            this.codes.setVisible(true);
        } else if (string == "comboBoxChanged") {
            this.recodeVariableList.setModel(new DefaultListModel());
        } else if (string == "OK") {
            if (this.codes == null || this.codes.getCodes() == "") {
                JOptionPane.showMessageDialog(this, "No Recodings Have been defined.\nClick on the 'Define Recode' button to specify...");
                return;
            }
            String string6 = (String)this.variableSelector.getJComboBox().getSelectedItem();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            DefaultListModel defaultListModel = (DefaultListModel)this.recodeVariableList.getModel();
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                String[] stringArray = ((String)defaultListModel.getElementAt(i)).split("\u2192");
                arrayList.add(stringArray[0]);
                arrayList2.add(stringArray[1]);
            }
            String string7 = RController.makeRStringVector(arrayList2);
            String string8 = RController.makeRStringVector(arrayList);
            Deducer.execute(string6 + "[" + string7 + "] <- recode.variables(" + string6 + "[" + string8 + "] , " + this.codes.getCodes() + ")");
            lastListModel = (DefaultListModel)this.recodeVariableList.getModel();
            lastDataName = (String)this.variableSelector.getJComboBox().getSelectedItem();
            this.dispose();
            Deducer.setRecentData(string6);
        }
    }

    private class RecodeDJList
    extends DJList {
        private RecodeDJList() {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            int n = this.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getModel().getElementAt(i);
                if (string.indexOf("\u2192") >= 0) continue;
                ((DefaultListModel)this.getModel()).removeElementAt(i);
                ((DefaultListModel)this.getModel()).add(i, string + "\u2192" + string);
            }
        }
    }
}

