/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.DataFrameComboBoxModel;
import org.rosuda.deducer.data.DataObject;
import org.rosuda.deducer.data.DataViewerController;
import org.rosuda.deducer.data.DataViewerTab;
import org.rosuda.deducer.data.Refresher;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.LoadData;
import org.rosuda.deducer.toolkit.SaveData;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.TJFrame;

public class DataViewer
extends TJFrame
implements ActionListener {
    private JTabbedPane tabbedPane;
    private JPanel dataSelectorPanel;
    private IconButton saveButton;
    private IconButton openButton;
    private IconButton removeButton;
    private JComboBox dataSelector;
    private ArrayList tabs = new ArrayList();
    private DataObject dataObj;

    public DataViewer() {
        super("Data Viewer", false, 154);
        try {
            DataViewerController.init();
            this.initGUI();
            DataViewerController.addViewerWindow(this);
            DataObject dataObject = (DataObject)this.dataSelector.getSelectedItem();
            String string = null;
            if (dataObject != null) {
                string = dataObject.getName();
            }
            this.dataObj = dataObject;
            this.reloadTabs(this.dataObj);
        }
        catch (Exception exception) {
            this.reloadTabs(null);
            exception.printStackTrace();
        }
        new Thread(new Refresher(this)).start();
    }

    private void initGUI() {
        try {
            this.setName("Data Viewer");
            DataViewerController.refreshData();
            BorderLayout borderLayout = new BorderLayout();
            this.getContentPane().setLayout(borderLayout);
            this.setDefaultCloseOperation(2);
            this.setMinimumSize(new Dimension(400, 400));
            this.dataSelectorPanel = new JPanel();
            this.getContentPane().add((Component)this.dataSelectorPanel, "North");
            AnchorLayout anchorLayout = new AnchorLayout();
            this.dataSelectorPanel.setLayout((LayoutManager)anchorLayout);
            this.dataSelectorPanel.setPreferredSize(new Dimension(839, 52));
            this.dataSelectorPanel.setSize(10, 10);
            this.dataSelectorPanel.setMinimumSize(new Dimension(100, 100));
            this.saveButton = new IconButton("/icons/kfloppy.png", "Save Data", this, "Save Data");
            this.saveButton.setContentAreaFilled(false);
            if (DataViewerController.showSaveDataButton()) {
                this.dataSelectorPanel.add((Component)this.saveButton, new AnchorConstraint(12, 60, 805, 62, 2, 0, 0, 2));
            }
            this.saveButton.setFont(new Font("Dialog", 0, 8));
            this.saveButton.setPreferredSize(new Dimension(32, 32));
            Serializable serializable = new JSeparator();
            this.dataSelectorPanel.add((Component)serializable, new AnchorConstraint(-76, 620, 1008, 608, 1, 1, 1, 1));
            serializable.setPreferredSize(new Dimension(10, 64));
            serializable.setOrientation(1);
            serializable = new JSeparator();
            this.dataSelectorPanel.add((Component)serializable, new AnchorConstraint(8, 415, 1076, 402, 1, 1, 1, 1));
            serializable.setPreferredSize(new Dimension(11, 63));
            serializable.setOrientation(1);
            serializable = new JLabel();
            this.dataSelectorPanel.add((Component)serializable, new AnchorConstraint(48, 595, 432, 415, 1, 1, 1, 1));
            ((JLabel)serializable).setText("Data Set");
            serializable.setPreferredSize(new Dimension(151, 20));
            serializable.setFont(new Font("Dialog", 0, 14));
            ((JLabel)serializable).setHorizontalAlignment(0);
            ((JLabel)serializable).setHorizontalTextPosition(0);
            serializable = new DataFrameComboBoxModel(DataViewerController.getDataSets());
            Object object = new BasicComboBoxRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    return super.getListCellRendererComponent((JList<?>)jList, object == null ? null : ((DataObject)object).getName(), n, bl, bl2);
                }
            };
            this.dataSelector = new JComboBox();
            this.dataSelectorPanel.add((Component)this.dataSelector, new AnchorConstraint(432, 594, 906, 415, 1, 1, 1, 1));
            this.dataSelector.setModel(serializable);
            this.dataSelector.setPreferredSize(new Dimension(149, 28));
            this.dataSelector.addActionListener(this);
            this.openButton = new IconButton("/icons/opendata_24.png", "Open Data", this, "Open Data");
            this.openButton.setContentAreaFilled(false);
            if (DataViewerController.showOpenDataButton()) {
                this.dataSelectorPanel.add((Component)this.openButton, new AnchorConstraint(12, 60, 805, 12, 2, 0, 0, 2));
            }
            this.openButton.setPreferredSize(new Dimension(32, 32));
            this.removeButton = new IconButton("/icons/trashcan_remove_32.png", "Remove from Workspace", this, "Clear Data");
            this.removeButton.setContentAreaFilled(false);
            if (DataViewerController.showClearDataButton()) {
                this.dataSelectorPanel.add((Component)this.removeButton, new AnchorConstraint(144, 12, 971, 863, 0, 2, 1, 0));
            }
            this.removeButton.setPreferredSize(new Dimension(40, 40));
            this.tabbedPane = new JTabbedPane();
            this.getContentPane().add((Component)this.tabbedPane, "Center");
            this.tabbedPane.setPreferredSize(new Dimension(839, 395));
            this.tabbedPane.setTabPlacement(2);
            if (!Common.isMac()) {
                this.tabbedPane.setTabPlacement(1);
            }
            this.pack();
            int n = Toolkit.getDefaultToolkit().getScreenSize().width - 100;
            int n2 = Toolkit.getDefaultToolkit().getScreenSize().height - 50;
            this.setSize(Math.min(839, n), Math.min(839, n2));
            object = this;
            this.addComponentListener(new ComponentAdapter((JFrame)object){
                final /* synthetic */ JFrame val$theFrame;
                {
                    this.val$theFrame = jFrame;
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.val$theFrame.setSize(Math.max(300, this.val$theFrame.getWidth()), this.val$theFrame.getHeight());
                }
            });
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Component component = DataViewer.this.tabbedPane.getSelectedComponent();
                    if (component instanceof DataViewerTab) {
                        DataViewerTab dataViewerTab = (DataViewerTab)component;
                        DataViewer.this.setJMenuBar(dataViewerTab.generateMenuBar());
                    }
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    DataViewerController.removeViewerWindow(DataViewer.this);
                    DataViewer.this.cleanUp();
                }
            });
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void reloadTabs(DataObject dataObject) {
        this.cleanUp();
        if (dataObject == null) {
            this.dataObj = null;
            JPanel jPanel = DataViewerController.getDefaultPanel();
            this.tabbedPane.removeAll();
            this.tabs.clear();
            this.tabbedPane.addTab("Get Started", jPanel);
            return;
        }
        try {
            this.dataObj = dataObject;
            String[] stringArray = DataViewerController.getTabNames(dataObject.getType());
            this.tabbedPane.removeAll();
            this.tabs.clear();
            for (int i = 0; i < stringArray.length; ++i) {
                DataViewerTab dataViewerTab = DataViewerController.generateTab(dataObject.getType(), stringArray[i], dataObject.getName());
                this.tabs.add(dataViewerTab);
                this.tabbedPane.addTab(stringArray[i], dataViewerTab);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setData(DataObject dataObject) {
        if (this.tabs.size() == 0) {
            this.reloadTabs(dataObject);
            return;
        }
        if (!dataObject.getType().equals(this.dataObj.getType())) {
            this.reloadTabs(dataObject);
            return;
        }
        this.dataObj = dataObject;
        for (int i = 0; i < this.tabs.size(); ++i) {
            DataViewerTab dataViewerTab = (DataViewerTab)this.tabs.get(i);
            dataViewerTab.setData(dataObject.getName());
        }
    }

    public DataObject getData() {
        return this.dataObj;
    }

    public void cleanUp() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            DataViewerTab dataViewerTab = (DataViewerTab)this.tabs.get(i);
            dataViewerTab.cleanUp();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string.equals("comboBoxChanged")) {
                DataObject dataObject = (DataObject)this.dataSelector.getSelectedItem();
                if (dataObject == null) {
                    return;
                }
                if (!dataObject.equals(this.dataObj)) {
                    this.setData(dataObject);
                    Deducer.setRecentData(dataObject.getName());
                }
            } else if (string == "Open Data") {
                new LoadData();
            } else if (string == "Save Data") {
                new SaveData(this.dataObj.getName());
            } else if (string == "Clear Data") {
                if (this.dataSelector.getSelectedItem() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Invalid selection: There is no data loaded.");
                    return;
                }
                String string2 = ((DataObject)this.dataSelector.getSelectedItem()).getName();
                int n = JOptionPane.showConfirmDialog(null, "Remove Data Frame " + string2 + " from environment?\nUnsaved changes will be lost.", "Clear Data Frame", 0, 3);
                if (n == 1) {
                    return;
                }
                Deducer.execute("rm(" + string2 + ")");
                RController.refreshObjects();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refresh() {
        ((DataFrameComboBoxModel)this.dataSelector.getModel()).refresh(DataViewerController.getDataSets());
        if ((DataObject)this.dataSelector.getSelectedItem() == null && this.dataObj != null) {
            this.reloadTabs(null);
            return;
        }
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof DataViewerTab) {
            ((DataViewerTab)component).refresh();
        }
    }
}

