% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inst.ratio.R
\name{inst.ratio}
\alias{inst.ratio}
\title{Computes instantaneous ratio of frequency}
\usage{
inst.ratio(
  pulse = NULL,
  dt = NULL,
  f = NULL,
  a = NULL,
  repl = 1,
  plot = TRUE,
  sqrt.rpwr = TRUE,
  style = "b",
  select = NA,
  bins = 100,
  cut = 18,
  lines = NULL,
  width = 10,
  height = 10,
  name = "Ratio",
  ext = ".pdf",
  dir = tempdir(),
  track = TRUE,
  openfile = TRUE
)
}
\arguments{
\item{pulse}{a pulse object (created by inst.pulse for instance)}

\item{dt}{depth/time. Is overridden by pulse.}

\item{f}{instantaneous frequency. Is overridden by pulse.}

\item{a}{instantaneous amplitude. Is overridden by pulse.}

\item{repl}{number of replicates in f}

\item{plot}{whether to plot an output}

\item{sqrt.rpwr, style, select, bins, cut, lines, width, height}{parameters to feed
to \code{\link{plot_ratio}} for the plots}

\item{name, ext, dir, track, openfile}{parameters to feed to
\code{\link[StratigrapheR]{pdfDisplay}} in \code{\link{plot_ratio}} for pdf plot.}
}
\value{
a list of depth/time ($dt), frequency ($f), ratio of frequency
($ratio), if a is provided; the ratio power ($rpwr) i.e. the multiplication
of the instantaneous amplitudes of the modes two by two, the replicates id
($repl)and id for the first and second frequency modes used for the ratio
($l for the first, $r for the second, or $lr for the two combined)
}
\description{
Computes instantaneous ratio of frequency
}
\examples{
set.seed(42)

n    <- 600
time <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(time *2*pi/p2)) * sin(time *2*pi/p1)  +
  2 * sin(time *2*pi/p2) + rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7, sifting = 10,
                repl = 10, comb = 10, factor_noise = 10,
                speak = TRUE)

\dontrun{
plot_emd(dec, dir = tempdir())}

integrity(xy, dec)
parsimony(dec)

ht    <- inst.pulse(dec, lines = c(30, 240))
ratio <- inst.ratio(ht, style = "s", lines = 8)

}
