% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_stats_temporal.R
\name{sum_stats_temporal}
\alias{sum_stats_temporal}
\title{Calculates summary statistics at specified time points relative to the
peak (or minimum)}
\usage{
sum_stats_temporal(relative_values)
}
\arguments{
\item{relative_values}{A list generated by \code{\link[=get_relative_values]{get_relative_values()}}.}
}
\value{
A list of data.frames of summary statistics.
}
\description{
For each policy alternative, this function calculates
summary statistics (n, mean, median, and IQR) for the model output values at
the specified time points relative to the peak (or minimum) value.
}
\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
D <- 750
t_s <- 20
t_ss <- 10

peak_values_list <- get_max_min_values(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt_max = TRUE
)

peak_temporal_list <- get_relative_values(
  psa_data,
  peak_values_list,
  t_s = t_s,
  t_ss = t_ss
)

stats_peak_temporal <- sum_stats_temporal(peak_temporal_list)
}
