% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trunc_gamma_para.R
\name{trunc_gamma_para}
\alias{trunc_gamma_para}
\title{Estimate Shape and Scale Parameters for Truncated Gamma Distribution}
\usage{
trunc_gamma_para(
  L,
  U,
  expert_data,
  weights = c(10, 10, 2, 1, 1),
  num_cores = 4,
  seed = NULL
)
}
\arguments{
\item{L}{Numeric. Lower bound of the truncated Gamma distribution.}

\item{U}{Numeric. Upper bound of the truncated Gamma distribution.}

\item{expert_data}{A list of named lists, where each inner list represents one expert's input. Each expert can provide any subset of the following named elements:
\describe{
\item{\code{mean}}{Numeric. The expected mean of the distribution.}
\item{\code{median}}{Numeric. The expected median of the distribution.}
\item{\code{sd}}{Numeric. The expected standard deviation of the distribution.}
\item{\code{q25}}{Numeric. The 2.5th percentile.}
\item{\code{q975}}{Numeric. The 97.5th percentile.}
}}

\item{weights}{Numeric vector of length 5. Specifies the relative importance of each summary statistic in the optimization procedure. The order corresponds to:
\code{c(mean, median, sd, q25, q975)}. Default is \code{c(10, 10, 2, 1, 1)}.}

\item{num_cores}{Integer. Number of CPU cores to use for parallel computation. Default is \code{4}.}

\item{seed}{Optional integer. If provided, sets the seed for reproducibility.}
}
\value{
A list with the following components:
\describe{
\item{shape}{Numeric. Estimated shape parameter of the Gamma distribution.}
\item{scale}{Numeric. Estimated scale parameter of the Gamma distribution.}
}
}
\description{
This function estimates the shape and scale parameters of a truncated Gamma distribution
based on expert-provided summary statistics, including the mean, median, standard deviation,
and selected quantiles. Parameter estimation is performed using a grid search combined with
weighted least squares optimization. Parallel computing is employed to accelerate the estimation process.
}
\examples{
# Define expert-provided summary data
expert_data_correct <- list(
  list(mean = 2.2, median = 2.27, sd = NULL, q25 = NULL, q975 = NULL),  # Expert A
  list(mean = 2.1, median = 2.3,  sd = NULL, q25 = NULL, q975 = NULL),  # Expert B
  list(mean = NULL, median = 2.31, sd = NULL, q25 = NULL, q975 = NULL)  # Expert C
)
\donttest{
  # Estimate parameters using truncated gamma prior
  trunc_gamma_para(L = 2,U = 2.5,expert_data = expert_data_correct,num_cores = 4)
}
}
