% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{update_priors}
\alias{update_priors}
\title{Update prior distributions using interim survival data}
\usage{
update_priors(data, control_model, effect_model, n_samples = 1000)
}
\arguments{
\item{data}{A data frame containing interim survival data with columns:
\itemize{
\item \code{survival_time} Observed time from randomisation to event/censoring.
\item \code{status} Event indicator (1 = event, 0 = censored).
\item \code{group} Group identifier (e.g., "Control", "Treatment").
}}

\item{control_model}{A named list specifying the control arm survival distribution:
\itemize{
\item \code{dist}: Distribution type ("Exponential" or "Weibull")
\item \code{parameter_mode}: Either "Fixed" or "Distribution"
\item \code{fixed_type}: If "Fixed", specify as "Parameters" or "Landmark"
\item \code{lambda}, \code{gamma}: Scale and shape parameters
\item \code{t1}, \code{t2}: Landmark times
\item \code{surv_t1}, \code{surv_t2}: Survival probabilities at landmarks
\item \code{t1_Beta_a}, \code{t1_Beta_b}, \code{diff_Beta_a}, \code{diff_Beta_b}: Beta prior parameters
}}

\item{effect_model}{A named list specifying beliefs about the treatment effect:
\itemize{
\item \code{delay_SHELF}, \code{HR_SHELF}: SHELF objects encoding beliefs
\item \code{delay_dist}, \code{HR_dist}: Distribution types ("hist" by default)
\item \code{P_S}: Probability that survival curves separate
\item \code{P_DTE}: Probability of delayed separation, conditional on separation
}}

\item{n_samples}{Number of posterior samples to generate (default: 1000).}
}
\value{
A data frame containing Monte Carlo samples from the updated (posterior)
distribution of the model parameters. Columns normally include:
\itemize{
\item \code{lambda_c} Posterior samples for the control hazard parameter.
\item \code{delay_time} Posterior samples for the delay/changepoint time \eqn{T}.
\item \code{HR} Posterior samples for the post-delay hazard ratio.
\item \code{gamma_c} (only if \code{control_distribution = "Weibull"})
Posterior samples for the Weibull shape parameter.
}

Priors for \code{lambda_c}, \code{T}, and \code{HR} are constructed from
elicited distributions using the SHELF framework, then updated through
sampling-based posterior inference.
}
\description{
This function updates elicited priors (defined through SHELF objects and
parametric prior distributions) using interim survival data under a
delayed-effect, piecewise-exponential model for the treatment arm and an
exponential or Weibull model for the control arm.
}
\examples{
set.seed(123)
interim_data = data.frame(survival_time = runif(10, min = 0, max = 10),
status = rbinom(10, size = 1, prob = 0.5),
group = c(rep("Control", 5), rep("Treatment", 5)))
control_model = list(dist = "Exponential",
                     parameter_mode = "Distribution",
                     t1 = 12,
                     t1_Beta_a = 20,
                     t1_Beta_b = 32)

effect_model = list(delay_SHELF = SHELF::fitdist(c(5.5, 6, 6.5),
                    probs = c(0.25, 0.5, 0.75), lower = 0, upper = 12),
                    delay_dist = "gamma",
                    HR_SHELF = SHELF::fitdist(c(0.5, 0.6, 0.7),
                    probs = c(0.25, 0.5, 0.75), lower = 0, upper = 1),
                    HR_dist = "gamma",
                    P_S = 1,
                    P_DTE = 0)

posterior_df <- update_priors(
  data = interim_data,
  control_model = control_model,
  effect_model = effect_model,
  n_samples = 10)


}
