% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DRPT.R
\name{DRPT}
\alias{DRPT}
\title{A function implementing the Density Ratio Permutation Test based on an
estimate of the shifted-MMD.}
\usage{
DRPT(X, Y, r, kernel, H = 99, S = 50)
}
\arguments{
\item{X}{A numeric vector containing the first sample.}

\item{Y}{A numeric vector containing the second sample.}

\item{r}{A function specifying the hypothesised density ratio.}

\item{kernel}{A function defining the kernel to be used for the U-statistic.}

\item{H}{An integer specifying the number of permutations to use. Defaults to 99.}

\item{S}{An integer specifying the number of steps for the Markov-Chain defined in Algorithm
2 in \insertCite{BB2025DRPT;textual}{DRPT}. Defaults to 50.}
}
\value{
The p-value of the DRPT as defined in (2) in \insertCite{BB2025DRPT;textual}{DRPT}.
}
\description{
A function that implements the DRPT based on the U-statistic (12)
defined in \insertCite{BB2025DRPT;textual}{DRPT}. An estimator of the shifted-MMD
with kernel \eqn{k(\cdot, \cdot)} as defined in Section 3.2 of the paper is computed using
the function \code{shiftedMMD}, which is provided in the package.
}
\examples{
n = 50; m = 50; d = 2
r = function(x,y) {
  return(4*x*y)
   }

gaussian.kernel = function(x, y, lambda = 1){
     return(lambda^(-d) * exp(-sum(((x - y) ^ 2) / (lambda ^ 2))))
     }

X = as.matrix(cbind(runif(n, 0, 1), runif(n, 0, 1)))
Y = as.matrix(cbind(rbeta(m, 0.5, 0.3), rbeta(m, 0.5, 0.4)))

DRPT(X,Y, r, gaussian.kernel, H=19, S=10)
DRPT(X,Y, r, gaussian.kernel, H=9)
}
\references{
\insertRef{BB2025DRPT}{DRPT}
}
