% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeliness_check.R
\name{timeliness_check}
\alias{timeliness_check}
\title{Perform timeliness Check for Data Frame Columns}
\usage{
timeliness_check(
  S_data,
  M_data,
  Result = FALSE,
  show_column = NULL,
  date_parser_fun = smart_to_gregorian_vec,
  var_select = "all",
  verbose = FALSE
)
}
\arguments{
\item{S_data}{data.frame. The source data in which rules will be evaluated. Each column may be referenced by the rules.}

\item{M_data}{data.frame. Metadata describing variables and their timeliness rules. Must include columns \code{VARIABLE}, \code{Timeliness_Rule} and \code{TYPE}. Optionally includes \code{Timeliness_Error_Type}.}

\item{Result}{logical (default: \code{FALSE}). If \code{TRUE}, returns row-by-row evaluation results for each rule. If \code{FALSE}, returns a summary table for each rule.}

\item{show_column}{character vector (default: \code{NULL}). Names of columns from \code{S_data} to include in the result when \code{Result = TRUE}. Ignored otherwise.}

\item{date_parser_fun}{function (default: \code{smart_to_gregorian_vec}). Converting Persian dates to English,Function to convert date values or date literals to \code{Date} class. Must accept character vectors and return \code{Date} objects.}

\item{var_select}{character, numeric, or \code{"all"} (default: \code{"all"}). Subset of variables (rules) to check. Can be a character vector of variable names, numeric vector of row indices in \code{M_data}, or \code{"all"} to run all rules.}

\item{verbose}{logical (default: \code{FALSE}). If \code{TRUE}, prints diagnostic messages during rule processing and evaluation.}
}
\value{
If \code{Result = FALSE}: a data.frame summary with columns:
\itemize{
  \item VARIABLE: Name of the variable/rule.
  \item Condition_Met: Number of rows where the rule is TRUE.
  \item Condition_Not_Met: Number of rows where the rule is FALSE.
  \item NA_Count: Number of rows with missing/indeterminate result.
  \item Total_Applicable: Number of non-NA rows.
  \item Total_Rows: Number of total rows.
  \item Percent_Met: Percentage of applicable rows meeting the condition.
  \item Percent_Not_Met: Percentage of applicable rows not meeting the condition.
  \item Timeliness_Error_Type: Error type from metadata (if available).
}
If \code{Result = TRUE}: a data.frame with one column per rule (variable), each containing logical values for every row, plus optional columns from the source data.
}
\description{
This function evaluates a source dataframe (`S_data`) against a set
of rules defined in a metadata dataframe (`M_data`).
it Checks timeliness rules (Temporal and availability conditions) on columns of a data frame, based on metadata specifications.
Supports flexible rule definition,date literal handling, and customizable output.
}
\details{
The metadata data.frame (\code{M_data}) **must** contain the following columns:
\itemize{
  \item \strong{VARIABLE}: Name of the variable in \code{S_data} to which the rule applies.
  \item \strong{Timeliness_Rule}: A logical rule provided as a string that defines temporal (date/time) conditions to be evaluated.
  \item \strong{TYPE}: Specifies the type of the variable (e.g., "numeric", "date", "character").
  \item \strong{Timeliness_Error_Type}: The error type for each rule will be reported in the summary output.Based on the importance and severity of the rule, it can include two options: "Warning" or "Error".
}

For each variable described in \code{M_data}, the function:
\itemize{
  \item Preprocesses the rule: replaces 'val' with the variable name, parses date literals and substitutes them with placeholders.
  \item Converts referenced data columns to appropriate types (numeric, date) based on metadata.
  \item Evaluates the rule for each row, either vectorized or row-wise if needed.
}
If \code{Result = FALSE}, returns a summary table with counts and percentages of rows meeting/not meeting each condition. If \code{Result = TRUE}, returns a data.frame with boolean results for each rule, optionally including selected columns from the source data.
}
\examples{
# Source data
S_data <- data.frame(
  VisitDate = c("2025-09-23", "2021-01-10", "2021-01-03","1404-06-28","1404-07-28",NA),
  Test_date = c("1404-07-01", "2021-01-09", "2021-01-14","1404-06-29","2025-09-19",NA)
)

# META DATA
M_data <- data.frame(
  VARIABLE = c("VisitDate","Test_date"),
  Timeliness_Rule = c(
    "",
    "VisitDate<=Test_date",
    " Test_date-VisitDate <10 ",
    ""),
  TYPE=c("date","date"),
  Timeliness_Error_Type = c("Error","warning"),
  stringsAsFactors = FALSE
)

result <- timeliness_check(
  S_data = S_data,
  M_data = M_data,
  Result = TRUE,
  show_column = FALSE
)

print(result)

result <- timeliness_check(
  S_data = S_data,
  M_data = M_data,
  Result = FALSE,
  var_select = c("VisitDate","Test_date")
)

print(result)

}
