% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPtree.R
\name{DPTreePMeanDensity}
\alias{DPTreePMeanDensity}
\title{Calculating sub-partition probabiltiy measures for the posterior mean distribution from D-P tree.}
\usage{
DPTreePMeanDensity(prior)
}
\arguments{
\item{prior}{A list. D-P tree specification. Should be in same format as returned from \code{DPTreePrior} or \code{DPTreePosterior}.}
}
\value{
A \eqn{2^m} by \eqn{2^m} matrix. Normalized measures for all \eqn{2^m} by \eqn{2^m} sub-partititons on copula space
given by the posterior mean distribution from D-P tree.
}
\description{
\code{DPTreePMeanDensity} returns
the probablity measures in the finest sub-partitions of the posterior mean from D-P tree.
}
\examples{
DPTreePMeanDensity(DPTreePrior(m=2, z=1))
}
\references{
\insertRef{DPtree}{DPtree}
}
