% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setCPT-Q.R
\name{setCPT.Q}
\alias{setCPT.Q}
\title{Set tables for auxiliary variables \code{Q}}
\usage{
setCPT.Q(
  domain,
  rho,
  xi,
  eta,
  phi,
  heights,
  n.unknown,
  n_K,
  Q,
  gets_stutter,
  can_stutter,
  stutter.from
)
}
\arguments{
\item{domain}{A \code{hugin.domain} modelling one marker}

\item{rho}{rho}

\item{xi}{xi}

\item{eta}{eta}

\item{phi}{phi ordered as \code{phi[c(U,K)]} where \code{U} and \code{K} are the names of unknown and known contributors.}

\item{heights}{Observed peak heights}

\item{n.unknown}{Number of unknown contributors}

\item{n_K}{Allelecounts for known contributors}

\item{Q}{Names for binary nodes}

\item{gets_stutter}{Does the allele receive stutter?}

\item{can_stutter}{Can the allele stutter?}

\item{stutter.from}{From which allele does the stutter come?}
}
\value{
Scaling factors to be set as evidence when conditioning on the peak heights
}
\description{
Function for setting the tables on all nodes \code{Q_r_a} for
mixture \code{r} in the network corresponding to one marker, using
peak heights and a set of parameters.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which is intended as a service to enable users to try \pkg{DNAmixtures} without purchasing a commercial licence for Hugin. When at all possible, we strongly recommend the use of \pkg{DNAmixtures} rather than this lite-version. See \url{https://dnamixtures.r-forge.r-project.org/} for details on both packages.}

\emph{While the lite-version seeks to provide the full functionality of \pkg{DNAmixtures}, note that computations are much less efficient and that there are some differences in available functionality. Be aware that the present documentation is copied from \pkg{DNAmixtures} and thus may not accurately describe the implementation of this lite-version.}
}
\details{
The function sets conditional probabilities for auxiliary variables \code{Q_r_a},
which are used for finding probabilities of observing a smaller or
larger peak than the one observed for the DNA mixture.
The conditional probability tables are defined using the gamma c.d.f. as
\deqn{P(\texttt{Q[a]} = \texttt{TRUE} | n_{ia}, n_{i,a+1}, i = 1,\ldots, k) = G(\texttt{heights[a]}).
}{P(Q[a] = TRUE | n_{ia}, n_{i,a+1}, i = 1,\ldots, k) = G(heights[a]).}
}
\seealso{
For further details see \code{\link{setCPT.O}}.
}
\author{
Therese Graversen
}
