% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{qqpeak}
\alias{qqpeak}
\title{Quantile-Quantile plot for assessing the distribution of observed peak heights.}
\usage{
qqpeak(
  x,
  pars,
  dist = c("joint", "conditional", "prequential"),
  by.allele = TRUE,
  plot = TRUE,
  xlab = "Uniform quantiles",
  ylab = NULL,
  xlim = NULL,
  ylim = xlim,
  ...
)
}
\arguments{
\item{x}{A \code{DNAmixture} model.}

\item{pars}{A \code{mixpar} parameter.}

\item{dist}{\code{"joint"}, \code{"conditional"}, or \code{"prequential"}. See \code{\link{predict.DNAmixture}} for details.}

\item{by.allele}{Order of conditioning when \code{dist="prequential"}. See \code{\link{predict.DNAmixture}}}

\item{plot}{Should a plot be produced? Defaults to \code{TRUE}.}

\item{xlab}{Legend for the x-axis.}

\item{ylab}{Legend for y-axis.}

\item{xlim}{Range of x-axis. Default is a plot with equal ranges
on the x- and y-axis.}

\item{ylim}{Range of y-axis.}

\item{...}{Other arguments to be passed on to \code{plot}.}
}
\value{
A \code{data.frame} containg quantiles \code{q}
corresponding to \eqn{P(Z < z_{obs} | Z > 0)} in the specified
distribution, together with other quantities computed by
\code{\link{predict.DNAmixture}}. The data are ordered according
to \code{q}.
}
\description{
Given \eqn{Z_a \ge C}, the peak height \eqn{Z_a} follows a
continuous distribution. The probability transform \eqn{P(Z_a \le z_a|
Z_a \ge C)} thus follows a uniform distribution. The function
\code{qqpeak} computes the quantiles of the probability transform
and produces a quantile-quantile plot. Information about the other
peak heights in the EPG may be taken into account in the
distribution of a peak.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\examples{
data(MC15, MC18, USCaucasian)
mix <- DNAmixture(list(MC15, MC18), C = list(50, 38), k = 3, K = c("K1", "K3"),
                  database = USCaucasian)
p <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = list(0.08,0.08),
            phi = list(c(U1 = 0.1, K3 = 0.2, K1 = 0.7)))
qqpeak(mix, pars = p, dist = "conditional")
\donttest{
## If desired, we can make a customised plot -- here we color according to the two mixtures
qq <- qqpeak(mix, pars = p, dist = "conditional", plot = FALSE)
plot(ppoints(qq$q), qq$q, xlab = "Uniform quantiles", ylab = "Probability transform",
     col = qq$trace, pch = qq$trace)
}
}
\author{
Therese Graversen
}
