test_that("single_glmre2 runs mixed-effects logistic regression correctly", {
  # Create dummy data
  set.seed(123)
  dummy_data <- data.frame(
    years_education = rnorm(100, 12, 3),
    gender_female = rbinom(100, 1, 0.5),
    household_wealth = sample(1:5, 100, replace = TRUE),
    district_code = sample(1:10, 100, replace = TRUE),
    HHid = as.character(rep(1:20, each = 5, length.out = 100))
  )

  # Create a binary outcome variable for years of education
  dummy_data$education_binary <- ifelse(dummy_data$years_education > 11, 1, 0)

  # Define a logistic regression formula
  formula <- education_binary ~ gender_female + household_wealth:gender_female

  # Run the mixed-effects logistic model for a specific district (suppress warnings)
  result <- suppressWarnings(single_glmre2(dummy_data, formula, "district_code", "HHid", location_index = 1, family = binomial()))

  # Test if the result contains the expected columns for estimates and std_error
  expect_true("estimate" %in% colnames(result))
  expect_true("std_error" %in% colnames(result))

  # Test if the result contains rows for Marginal and Conditional R-squared
  expect_true(any(result$term == "Marginal R-squared"))
  expect_true(any(result$term == "Conditional R-squared"))
})
