% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{extractCoverageFromVcf}
\alias{extractCoverageFromVcf}
\title{Extract VCF information}
\usage{
extractCoverageFromVcf(filename, samplename)
}
\arguments{
\item{filename}{VCF file name.}

\item{samplename}{Sample name}
}
\value{
A dataframe list with members of haplotypes, proportions and log likelihood of the MCMC chain.
\itemize{
  \item \code{CHROM} SNP chromosomes.
  \item \code{POS} SNP positions.
  \item \code{refCount} reference allele count.
  \item \code{altCount} alternative allele count.
}
}
\description{
Extract VCF information
}
\examples{
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid.utils")
vcf = extractCoverageFromVcf(vcfFile, "PG0390-C")

}
\seealso{
\itemize{
  \item \code{extractCoverageFromVcf}
  \item \code{extractCoverageFromTxt}
}
}
