% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAnalysis.R
\name{plus_minus_setup}
\alias{plus_minus_setup}
\title{plus_minus_setup}
\usage{
plus_minus_setup(evaluated, attributes, minus, plus)
}
\arguments{
\item{evaluated}{An evaluated alternative.}

\item{attributes}{Vector of \link{DexiAttribute} objects involved in \code{plus-minus} analysis.}

\item{minus}{A single integer: Maximum steps down.}

\item{plus}{A single integer: Maximum steps up.}
}
\value{
A data frame consisting of columns:
\describe{
\item{\code{"id"}}{Attribute IDs.}
\item{\code{"structure"}}{Attribute \verb{$structure() + $name}.}
\item{\code{counts}}{Attributes' scale sizes.}
\item{\code{low_bounds}}{Low bounds of attributes' values.}
\item{\code{high_bounds}}{High bounds of attributes' values.}
\item{\code{low_diff}}{Maximum possible value decrease given \code{low_bound} and attribute scale.}
\item{\code{high_diff}}{Maximum possible value increase given \code{high_bound} and attribute scale.}
\item{\code{evals}}{Alternative evaluation for the corresponding attribute (from \code{evaluated}).}
\item{\code{sets}}{\code{evals} represented as value sets.}
}
}
\description{
A helper function: Initializes a data frame for \code{\link[=plus_minus]{plus_minus()}}.
}
\seealso{
\code{\link[=plus_minus]{plus_minus()}}
}
