% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiEvaluate.R
\name{evaluate}
\alias{evaluate}
\title{evaluate}
\usage{
evaluate(
  model,
  alternatives = model$alternatives,
  root = model$root,
  method = EnumEvalMethod,
  bounding = FALSE,
  prune = list(),
  norm = NULL,
  and = NULL,
  or = NULL
)
}
\arguments{
\item{model}{\link{DexiModel}.}

\item{alternatives}{A data frame containing data of one or more decision alternatives.}

\item{root}{\link{DexiAttribute}. Default: \code{model$root}.}

\item{method}{One of: \code{"set"} (default), \code{"prob"}, \code{"fuzzy"} or \code{"fuzzynorm"}.}

\item{bounding}{\code{logical(1)}. When \code{TRUE}, evaluation results are additionally subjected to
\code{\link[=bounded_scale_value]{bounded_scale_value()}} to keep them in the bounds set up by the corresponding scale.}

\item{prune}{\code{character()}, containing IDs of aggregate attributes that should be treated as
evaluation inputs (rather than basic attributes).}

\item{norm}{Some normalization function of the form \verb{function(num_vector)}, or \code{NULL}.}

\item{and}{Some conjunctive aggregation function of the form \verb{function(num_vector)}, or \code{NULL}.}

\item{or}{Some disjunctive aggregation function of the form \verb{function(num_vector)}, or \code{NULL}.}
}
\value{
A data frame containing both input and output (evaluated) values of \code{alternatives}.
}
\description{
Evaluates decision alternatives. Essentially, this is a bottom-up aggregation method:
starting with basic attributes (or \code{prune}d aggregate attributes), values of each
alternative are gradually aggregated towards the \code{root} attribute,
according to \code{\link[=evaluation_order]{evaluation_order()}}. The aggregation
at each individual \link{DexiAttribute} is governed by the corresponding \code{DexiAttribute$funct}.
When alternative values are sets or distributions (see \link{DEXiR-package}),
then \code{\link[=evaluate]{evaluate()}} tries all possible combinations of values of the descendant attributes.
}
\details{
\code{\link[=evaluate]{evaluate()}} implements four aggregation methods:
\code{"set"}, \code{"prob"}, \code{"fuzzy"} and \code{"fuzzynorm"}.

The \code{"set"} method interprets DEXi values as sets. The output value assigned to some \code{attribute} is
composed of the union of all \code{attribute$funct} evaluations for all possible combinations of values of
\code{attribute$inputs}.

The remaining three methods interpret DEXi values as value distributions. They follow the same algorithm,
but use different functions (see \code{\link[=evaluation_parameters]{evaluation_parameters()}}) in three algorithm steps:
normalization, and conjunctive and disjunctive aggregation. All values distributions involved in
calculations are normalized by the function \code{norm()}. All combinations of \code{attribute$input}
values are individually evaluated by the corresponding tabular function \code{attribute$funct}.
The value \eqn{p} of each set of \code{attribute$funct} arguments is determined by the conjunctive
aggregation function \code{and()} over \eqn{p}'s of individual arguments.
Finally, the \eqn{p} of some output value \code{val} is determined by the
disjunctive aggregation function \code{or()}, applied on the \eqn{p}'s of all partial evaluations that
map to \code{val}.

For the mathematical background and more details about aggregation in DEX, please see
(Trdin, Bohanec, 2018). For default normalization and aggregation functions,
see \code{\link[=normalize_function]{normalize_function()}}, \code{\link[=and_function]{and_function()}} and \code{\link[=or_function]{or_function()}}.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

alt <- Car$alternative("MyCar_set",
         BUY.PRICE="low", MAINT.PRICE=2, X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY="medium")
Car$evaluate(alt)

# Try the set-based evaluation using the default "set" method
alt <- Car$alternative("MyCar2",
       BUY.PRICE="low", MAINT.PRICE="*", X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY=2)
Car$evaluate(alt)

# Use value distributions and try the methods "prob", "fuzzy" and "fuzzynorm"
alt <- Car$alternative("MyCar_distr",
       BUY.PRICE="low", MAINT.PRICE=distribution(0.1, 0.6, 0.3),
       X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY=2)
Car$evaluate(alt, method = "prob")
Car$evaluate(alt, method = "fuzzy")
Car$evaluate(alt, method = "fuzzynorm")

}
\seealso{
\code{\link[=evaluation_parameters]{evaluation_parameters()}}, \code{\link[=normalize_function]{normalize_function()}},
\code{\link[=norm_none]{norm_none()}}, \code{\link[=norm_max]{norm_max()}}, \code{\link[=norm_sum]{norm_sum()}}, \code{\link[=and_function]{and_function()}}, \code{\link[=or_function]{or_function()}}, \code{\link[=bounded_scale_value]{bounded_scale_value()}}.
}
