% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_ExpEIN.R
\name{DAISIE_ExpEIN}
\alias{DAISIE_ExpEIN}
\title{The expected number of endemics and non-endemics under the DAISIE model with
no diversity-dependence}
\usage{
DAISIE_ExpEIN(tvec, pars, M, initEI = c(0, 0))
}
\arguments{
\item{tvec}{The times at which the probabilities need to be computed.}

\item{pars}{A numeric vector containing the model parameters:
\itemize{
  \item{\code{pars[1]}: lambda^c (cladogenesis rate)}
  \item{\code{pars[2]}: mu (extinction rate)}
  \item{\code{pars[3]}: K (carrying capacity), set K=Inf for diversity
  independence.}
  \item{\code{pars[4]}: gamma (immigration rate)}
  \item{\code{pars[5]}: lambda^a (anagenesis rate)}
  \item{\code{pars[6]}: lambda^c (cladogenesis rate) for either type 2 species
  or rate set 2 in rate shift model}
  \item{\code{pars[7]}: mu (extinction rate) for either type 2 species or rate
  set 2 in rate shift model}
  \item{\code{pars[8]}: K (carrying capacity) for either type 2 species or rate
  set 2 in rate shift model, set K=Inf for diversity independence.}
  \item{\code{pars[9]}: gamma (immigration rate) for either type 2 species
  or rate set 2 in rate shift model}
  \item{\code{pars[10]}: lambda^a (anagenesis rate) for either type 2
  species or rate set 2 in rate shift model}
}
Elements 6:10 are required only when type 2 species are included
or in the rate shift model. For \code{\link{DAISIE_sim_relaxed_rate}()}
\code{pars[6]} is the standard deviation of the gamma distribution for the
relaxed parameter and the parameter chosen by the \code{relaxed_par}
argument is the mean of the gamma distribution for the relaxed parameter.}

\item{M}{Numeric defining the size of mainland pool, i.e. the number of
species that can potentially colonize the island.}

\item{initEI}{The initial values for the number of endemics and
  non-endemics. In \code{\link{DAISIE_probdist}()} or
\code{\link{DAISIE_margprobdist}()} either this or initprobs must be NULL. In
\code{\link{DAISIE_numcol}()} when it is NULL, it is assumed that the island
  is empty.}
}
\value{
The output is a list with three elements: \cr \cr
\code{ExpE} The number of endemic species \cr
\code{ExpI} The number of non-endemic species \cr
\code{ExpN} The sum of the number of endemics and non-endemics
}
\description{
This function calculates the expected number of endemics, non-endemics and
the sum of these for a given set of parameter values, a given mainland
species pool size and a given time, assuming no diversity-dependence
}
\examples{

### Compute the expected values at t = 4, for a mainland pool size of 1000 potential
# colonists and a vector of 5 parameters (cladogenesis, extinction, clade-level carrying
# capacity, immigration, anagenesis)

DAISIE_ExpEIN(
   tvec = c(2,4),
   pars = c(0.5,0.1,Inf,0.01,0.4),
   M = 1000
   )

}
\references{
Valente, L.M., A.B. Phillimore and R.S. Etienne (2015).
Equilibrium and non-equilibrium dynamics simultaneously operate in the
Galapagos islands. Ecology Letters 18: 844-852.
}
\author{
Rampal S. Etienne
}
\keyword{models}
