% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE-package.R
\docType{package}
\name{DAISIE-package}
\alias{DAISIE}
\alias{DAISIE-package}
\title{DAISIE: Dynamical Assembly of Islands by Speciation, Immigration and Extinction}
\description{
DAISIE is an island biogeography model that assumes island biota
assembly is governed by immigration, extinction and speciation through cladogenesis
and anagenesis. This likelihood-based statistical package can simulate islands and
estimate parameters of the DAISIE model based on phylogenetic/phylogeographic data.
Cladogenesis and immigration rates can be dependent on diversity.
}
\references{
\itemize{
\item Valente, L. M., Etienne, R. S., & Phillimore, A. B. (2014). The effects of island ontogeny on species diversity and phylogeny. Proceedings of the Royal Society of London. Series B, Biological Sciences 281, 20133227. \doi{10.1098/rspb.2013.3227}. \cr
\item Valente, L., A.B. Phillimore & R.S. Etienne (2015). Equilibrium and non-equilibrium dynamics simultaneously operate in the Galapagos islands. Ecology Letters 18: 844-852, \doi{10.1111/ele.12461}. \cr
\item Valente, L., R.S. Etienne & L. Davalos (2017). Recent extinctions disturb path to equilibrium diversity in Caribbean bats. Nature Ecology and Evolution 1: 0026. \doi{10.1038/s41559-016-0026}.\cr
\item Valente, L., Illera, J. C., Havenstein, K., Pallien, T., Etienne, R. S., & Tiedemann, R. (2017). Equilibrium Bird Species Diversity in Atlantic Islands. Current Biology 27: 1660-1666. \doi{10.1016/j.cub.2017.04.053}.\cr
\item Valente, L., Phillimore, A. B., & Etienne, R. (2018). Using molecular phylogenies in island biogeography: It's about time. Ecography 41: 1684-1686. \doi{10.1111/ecog.03503}.\cr
\item Valente, L., Etienne, R. S., & Garcia-R, J. C. (2019). Deep macroevolutionary impact of humans on New Zealand's unique avifauna. Current Biology 29: 2563-2569. \doi{10.1016/j.cub.2019.06.058}.\cr
\item Valente, L., Phillimore, A. B., Melo, M., Warren, B. H., Clegg, S. M., Havenstein, K., & Etienne, R. S. (2020). A simple dynamic model explains the diversity of island birds worldwide. Nature 579: 92-96. \doi{10.1038/s41586-020-2022-5}.\cr
\item Hauffe, T., Delicado, D., Etienne, R.S., & Valente, L. (2020). Lake expansion elevates equilibrium diversity via increasing colonization. Journal of Biogeography 47: 1849–1860. \doi{10.1111/jbi.13914}.\cr
\item Valente, L., Kristensen, N., Phillimore, A. B., & Etienne, R. S. (2021). Report of programming bugs in the DAISIE R package: consequences and correction. EcoEvoRxiv. \doi{10.32942/osf.io/w5ntf}.\cr
\item Santos Neves, P., Lambert, J. W., Valente, L., & Etienne, R. S. (2022). The robustness of a simple dynamic model of island biodiversity to geological and sea-level change. Journal of Biogeography 49: 2091-2104. \doi{10.1111/jbi.14519}.\cr
\item Lambert, J. W., Santos Neves, P., Bilderbeek, R. L. C., Valente, L., Etienne, R. S. (2022). The effect of mainland dynamics on data and parameter estimates in island biogeography. bioRxiv. \doi{10.1101/2022.01.13.476210}.\cr
\item Xie, S., Valente, L., Etienne, R. S. (2023). Can we ignore trait-dependent colonization and diversification in island biogeography? Evolution. \doi{10.1093/evolut/qpad006}.\cr
\item Michielsen, N. M., Goodman, S. M., Soarimalala, V., van der Geer, A. A. E., Dávalos, L. M., Saville, G. I., Upham, N., Valente, L. (2023). The macroevolutionary impact of recent and imminent mammal extinctions on Madagascar. Nature Communications 14 (14).\doi{10.1038/s41467-022-35215-3}.\cr
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/rsetienne/DAISIE}
  \item \url{https://rsetienne.github.io/DAISIE/}
  \item Report bugs at \url{https://github.com/rsetienne/DAISIE/issues}
}

}
\author{
\strong{Maintainer}: Rampal S. Etienne \email{r.s.etienne@rug.nl} (\href{https://orcid.org/0000-0003-2142-7612}{ORCID})

Authors:
\itemize{
  \item Luis Valente \email{luis.valente@naturalis.nl} (\href{https://orcid.org/0000-0003-4247-8785}{ORCID})
  \item Albert B. Phillimore (\href{https://orcid.org/0000-0002-6553-1553}{ORCID})
  \item Bart Haegeman (\href{https://orcid.org/0000-0003-2325-4727}{ORCID})
  \item Joshua W. Lambert \email{j.w.l.lambert@rug.nl} (\href{https://orcid.org/0000-0001-5218-3046}{ORCID})
  \item Pedro Santos Neves \email{p.m.santos.neves@rug.nl} (\href{https://orcid.org/0000-0003-2561-4677}{ORCID})
  \item Shu Xie \email{s.xie@rug.nl} (\href{https://orcid.org/0000-0001-9594-946X}{ORCID})
  \item Richèl J.C. Bilderbeek \email{richel@richelbilderbeek.nl} (\href{https://orcid.org/0000-0003-1107-7049}{ORCID})
  \item Hanno Hildenbrandt \email{h.hildenbrandt@rug.nl} (\href{https://orcid.org/0000-0002-6784-1037}{ORCID})
}

Other contributors:
\itemize{
  \item Torsten Hauffe \email{torsten.hauffe@gmail.com} (\href{https://orcid.org/0000-0001-5711-9457}{ORCID}) [contributor]
  \item Giovanni Laudanno \email{glaudanno@gmail.com} (\href{https://orcid.org/0000-0002-2952-3345}{ORCID}) [contributor]
  \item Nadiah Kristensen \email{nadiah@nadiah.org} (\href{https://orcid.org/0000-0002-9720-4581}{ORCID}) [contributor]
  \item Ornela Dehayem Nanwou \email{o.d.nanwou@rug.nl} (\href{https://orcid.org/0009-0009-0507-1215}{ORCID}) [contributor]
  \item Raphael Scherrer \email{r.scherrer@rug.nl} (\href{https://orcid.org/0000-0002-1447-7630}{ORCID}) [contributor]
}

}
\keyword{internal}
