% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_cox_model_from_files}
\alias{fit_cox_model_from_files}
\title{Step 2: Fit Cox Model from Files}
\usage{
fit_cox_model_from_files(
  phenotype_file,
  covariate_file,
  output_file = NULL,
  use_spacox = TRUE
)
}
\arguments{
\item{phenotype_file}{Path to CSV file with columns: IID, time, status}

\item{covariate_file}{Path to CSV file with columns: IID, covar1, covar2, ...}

\item{output_file}{Path to RDS file to save the fitted null model (default: temporary directory)}

\item{use_spacox}{Legacy parameter, kept for compatibility (ignored)}
}
\value{
Invisible path to the output file
}
\description{
Implements Step 2 of the CoxMK workflow: fitting a null Cox proportional hazards model
by reading phenotype and covariate data from files. This function is designed for 
batch processing and large-scale analysis where data is stored in separate files.
}
\examples{
\donttest{
# Prepare example data files
pheno_data <- data.frame(
  IID = paste0("ID", 1:100),
  time = rexp(100, 0.1),
  status = rbinom(100, 1, 0.3)
)
covar_data <- data.frame(
  IID = paste0("ID", 1:100),
  age = rnorm(100, 50, 10),
  sex = rbinom(100, 1, 0.5)
)

# Use temporary directory for file operations to comply with CRAN policies
temp_dir <- tempdir()
pheno_file <- file.path(temp_dir, "phenotype.csv")
covar_file <- file.path(temp_dir, "covariates.csv")
output_file <- file.path(temp_dir, "null_model.rds")

write.csv(pheno_data, pheno_file, row.names = FALSE)
write.csv(covar_data, covar_file, row.names = FALSE)

# Step 2: Fit null Cox model from files
fit_cox_model_from_files(
  phenotype_file = pheno_file,
  covariate_file = covar_file, 
  output_file = output_file
)

# Load the fitted model for Step 3
model_info <- readRDS(output_file)
}
}
