% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{cox_knockoff_analysis}
\alias{cox_knockoff_analysis}
\title{Complete Cox Knockoff Analysis Workflow}
\usage{
cox_knockoff_analysis(
  plink_prefix,
  time,
  status,
  covariates = NULL,
  sample_ids = NULL,
  null_model = NULL,
  gds_file = NULL,
  M = 5,
  fdr = 0.05,
  method = "median",
  output_dir = NULL
)
}
\arguments{
\item{plink_prefix}{Character string. Path prefix for PLINK files (.bed, .bim, .fam)}

\item{time}{Numeric vector. Survival times}

\item{status}{Numeric vector. Censoring indicator (1 = event, 0 = censored)}

\item{covariates}{Data frame or matrix. Covariate data (optional)}

\item{sample_ids}{Character vector. Sample IDs to match with genetic data (optional)}

\item{null_model}{Fitted Cox model object for null hypothesis (optional)}

\item{gds_file}{Character string. Path to pre-generated GDS file with knockoffs (optional)}

\item{M}{Integer. Number of knockoff copies to generate (default: 5)}

\item{fdr}{Numeric. Target false discovery rate (default: 0.05)}

\item{method}{Character. Method for computing W statistics ("median", "difference", "ratio")}

\item{output_dir}{Character string. Directory to save intermediate results (default: NULL, uses tempdir())}
}
\value{
List containing:
  \item{selected_vars}{Indices of selected variables}
  \item{W_stats}{W statistics for all variables}
  \item{threshold}{Knockoff threshold used}
  \item{gds_file}{Path to GDS file used}
  \item{null_model}{Fitted null Cox model}
  \item{test_results}{SPA test results}

List containing:
\itemize{
  \item W_stats - Vector of W statistics for each variant
  \item selected_vars - Indices of selected variants
  \item knockoffs - Generated knockoff matrix (if gds_file not provided)
  \item summary - Summary statistics of the analysis
}
}
\description{
Performs a complete Multiple knockoff analysis following the four-step workflow:
1. Generate knockoff variables from PLINK data and save to GDS format
2. Fit null Cox model using optimized Cox regression for large-scale analysis
3. Perform SPA testing using original and knockoff variables
4. Apply knockoff filter for variable selection with FDR control
}
\examples{
\donttest{
# Simple workflow example
# Load example data
extdata_path <- system.file('extdata', package = 'CoxMK')
plink_prefix <- file.path(extdata_path, 'sample')
pheno_data <- read.table(file.path(extdata_path, 'tte_phenotype.txt'), 
                        header = TRUE, stringsAsFactors = FALSE)
covar_data <- read.table(file.path(extdata_path, 'covariates.txt'), 
                        header = TRUE, stringsAsFactors = FALSE)
covar_data <- covar_data[, c("age", "sex", "bmi", "smoking")]

# Run complete analysis
result <- cox_knockoff_analysis(
  plink_prefix = plink_prefix,
  time = pheno_data$time,
  status = pheno_data$status,
  covariates = covar_data,
  M = 3,
  fdr = 0.1
)

# View results
print(result$selected_vars)
print(result$summary)
}
}
