% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMutProteins.R
\name{plotMutProteins}
\alias{plotMutProteins}
\title{Plot the most frequent mutational events for proteins in the SARS-CoV-2 genome}
\usage{
plotMutProteins(
  covid_annot = covid_annot,
  proteinName = "NSP2",
  top = 20,
  outdir = NULL
)
}
\arguments{
\item{covid_annot}{The mutation effects provided by "indelSNP" function.}

\item{proteinName}{Proteins in the SARS-CoV-2 genome, available choices:
5'UTR, NSP1~NSP10, NSP12a, NSP12b, NSP13, NSP14, NSP15, NSP16, S, ORF3a,
E, M, ORF6, ORF7a, ORF7b, ORF8, N, ORF10.}

\item{top}{The number of objects to display.}

\item{outdir}{The output directory.}
}
\value{
Plot the mutational events for selected proteins as output.
}
\description{
Plot the most frequent mutational events for proteins selected.
The protein name should be specified correctly (only for SARS-CoV-2).
}
\examples{
data("covid_annot")
# make sure the covid_annot is a dataframe
covid_annot <- as.data.frame(covid_annot)
#outdir <- tempdir() specify your output directory
plotMutProteins(covid_annot = covid_annot,proteinName = "NSP2", top = 20, outdir = NULL)
}
