% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalProteinMut.R
\name{globalProteinMut}
\alias{globalProteinMut}
\title{Global mutational events profiling of proteins}
\usage{
globalProteinMut(
  covid_annot = covid_annot,
  outdir = NULL,
  figure_Type = "heatmap",
  top = 10,
  country = "global"
)
}
\arguments{
\item{covid_annot}{The mutation effects provided by "indelSNP" function.}

\item{outdir}{The output directory.}

\item{figure_Type}{Figure type for either "heatmap" or "count".}

\item{top}{The number of variants to plot.}

\item{country}{Choose a country to plot the mutational pattern or
choose "global" to profile mutations across all countries. The
default is "global".}
}
\value{
Plot the selected figure type as output.
}
\description{
This function is to visualize the global protein mutational pattern in the
SARS-CoV-2 genome.
}
\examples{
data("covid_annot")
outdir <- tempdir()
# make sure the covid_annot is a dataframe
covid_annot <- as.data.frame(covid_annot)
globalProteinMut(covid_annot = covid_annot,
                 outdir = outdir,
                 figure_Type = "heatmap",
                 top = 10,
                 country = "USA")
}
