% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssayMutRatio.R
\name{AssayMutRatio}
\alias{AssayMutRatio}
\title{Calculate the mutation detection rate using different assays}
\usage{
AssayMutRatio(
  nucmerr = nucmerr,
  assays = assays,
  totalsample = totalsample,
  plotType = "barplot",
  outdir = NULL
)
}
\arguments{
\item{nucmerr}{Mutation information containing group list(derived from "nucmer" object using "nucmerRMD" function).}

\item{assays}{Assays dataframe including the detection ranges of mutations.}

\item{totalsample}{Total sample number, total cleared GISAID fasta data.}

\item{plotType}{Figure type for either "barplot" or "logtrans".}

\item{outdir}{The output directory.}
}
\value{
Plot the selected figure type as output.
}
\description{
This function is to use the well established assays information to detect mutations in different
SARS-CoV-2 genomic sites. The output will be series of figures presenting the mutation profile using a
specific assay and a figure for comparison between the mutation detection rate in each primers binding region.
}
\examples{
data("nucmerr")
data("assays")
Total <- 52 ## Total Cleared GISAID fasta data, sekitseq
#outdir <- tempdir()
#Output the results
AssayMutRatio(nucmerr = nucmerr,
              assays = assays,
              totalsample = Total,
              plotType = "logtrans",
              outdir = NULL)
}
