% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_est.R
\name{to_vario}
\alias{to_vario}
\title{Autocovariance to Semivariogram}
\usage{
to_vario(estCov)
}
\arguments{
\item{estCov}{A vector whose values are an estimate autocovariance function.}
}
\value{
A vector whose values are an estimate of the semivariogram.
}
\description{
This function computes an estimated semivariogram using an estimated autocovariance function.
}
\details{
The semivariogram, \eqn{\gamma(h)} and autocovariance function, \eqn{C(h)}, under the assumption of weak stationarity are related as follows:
\deqn{
\gamma(h) = C(0) - C(h) .
}

When an empirical autocovariance function is considered instead, this relation does not necessarily hold, however,
it can be used to obtain a function that is close to a semivariogram, see Bilchouris and Olenko (2025).
}
\examples{
X <- c(1, 2, 3)
estCov <- standard_est(X, meanX=mean(X), maxLag = 2, pd=FALSE)
to_vario(estCov)
}
\references{
Bilchouris, A. & Olenko, A (2025). On Nonparametric Estimation of Covariogram. Austrian Statistical Society 54(1), 112-137. 10.17713/ajs.v54i1.1975
}
