% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{check_pd}
\alias{check_pd}
\title{Check if an Autocovariance Function Estimate is Positive-Definite or Not.}
\usage{
check_pd(est)
}
\arguments{
\item{est}{A numeric vector or corresponding cyclic matrix representing an estimated autocovariance function.}
}
\value{
A boolean where \code{TRUE} denotes a positive-definite autocovariance function estimate and \code{FALSE} for an estimate that is not positive-definite.
}
\description{
This function checks if an autocovariance function estimate is positive-definite or not by determining if the eigenvalues of the corresponding matrix (see the Details section) are all positive.
}
\details{
For an autocovariance function estimate \eqn{\hat{C}(\cdot)} over a set of lags separated by a constant difference \eqn{\{h_{0}, h_{1} , h_{2} , \dots , h_{n} \},}
construct the symmetric matrix
\deqn{\left[ {\begin{array}{ccccc}
\hat{C}(h_{0})     & \hat{C}(h_{1})     & \cdots & \hat{C}(h_{n - 1}) & \hat{C}(h_{n})     \\
\hat{C}(h_{1})     & \hat{C}(h_{0})     & \cdots & \hat{C}(h_{n - 2}) & \hat{C}(h_{n - 1}) \\
\vdots             & \vdots             & \ddots & \vdots             & \vdots             \\
\hat{C}(h_{n - 1}) & \hat{C}(h_{n - 2}) & \cdots & \hat{C}(h_{0})     & \hat{C}(h_{1})     \\
\hat{C}(h_{n})     & \hat{C}(h_{n - 1}) & \cdots & \hat{C}(h_{1})     & \hat{C}(h_{0})     \\
\end{array}} \right] .
}

The eigendecomposition of this matrix is computed to determine if all eigenvalues are positive. If so, the estimated autocovariance function is assumed to be positive-definite.
}
\examples{
x <- seq(0, 5, by=0.1)
estCov <- exp(-x^2)
check_pd(estCov)
check_pd(cyclic_matrix(estCov))
}
