% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rncs.R
\name{rncs}
\alias{rncs}
\title{Simulation of non-central squared copula}
\usage{
rncs(n, family, rotation = 0, par)
}
\arguments{
\item{n}{Number of observations}

\item{family}{Copula family: "ncs-gaussian", "ncs-clayton", "ncs-frank", "ncs-gumbel", "ncs-joe", "ncs-plackett''.}

\item{rotation}{Rotation: 0 (default value), 90, 180, or 270.}

\item{par}{vector of copula parameter  and non-centrality parameter a1,a2 >0}
}
\value{
\item{U}{Observations}
}
\description{
This function computes generates a bivariate sample from a non-central squared copula (ncs)  associated with a one-parameter copula with parameter cpar, and parameters a1, a2 >0 .
}
\examples{
rncs(100,"ncs-clayton",par=c(2,1,2))


}
\references{
Nasri (2020). On non-central squared copulas. Statistics and Probability Letters.
}
