% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_options.R
\name{est_options}
\alias{est_options}
\title{Options for the estimation of the parameters of bivariate copula-based models}
\usage{
est_options(family, tau = 0.5)
}
\arguments{
\item{family}{Copula family: "gaussian", "t", "clayton", "frank", "gumbel", "joe", "plackett'', "bb1", "bb6", "bb7","bb8","ncs-gaussian", "ncs-clayton", "ncs-gumbel", "ncs-frank", "ncs-joe","ncs-plackett".}

\item{tau}{Estimated Kendall's tau to compute a starting point (default is 0.5)}
}
\value{
\item{LB}{Lower bound for the parameters}

\item{UB}{Upper bound for the parameters}

\item{start}{Starting point for the estimation}
}
\description{
Sets starting values, upper and lower bounds for the parameters. The bounds are based on those in the rvinecopulib package.
}
\examples{
out = est_options("bb8")


}
\references{
Nagler & Vatter (2002). rvinecopulib: High Performance Algorithms for Vine Copula Modeling. Version 0.6.2.1.3

Nasri (2020). On non-central squared copulas. Statistics and Probability Letters.

Nasri (2022). Test of serial dependence for arbitrary distributions. JMVA.

Nasri & Remillard (2023). Copula-based dependence measures for arbitrary data, arXiv 2301.07267.
}
