% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copc1.r
\name{estCopC}
\alias{estCopC}
\title{Pseudo maximum likelihood estimator of the copula parameter}
\usage{
estCopC(cop="Gaussian",Yc,d,delta,nIS=500,jumps=NULL,MARGIN=NULL,...,interval=NULL)
}
\arguments{
\item{cop}{the choice of copula function.
There are currently five available copula funcitons,
including Clayton copula, Gaussian copula, Gumbel copula, Joe copula and Frank copula.
Specify one from "Clayton","Gaussian","Gumbel","Joe" and "Frank".
The default is "Gaussian".}

\item{Yc}{the Nx1 vector of observed response variable
that is subject to lower detection limit.}

\item{d}{the lower detection limit.}

\item{delta}{the Nx1 vector of censoring indicator
with 1 indicating uncensored and 0 indicating left censored.}

\item{nIS}{the size for sequential importance sampling.
The default is 500.}

\item{jumps}{the Nx1 vector indicating whether
each time t is a start of a new time series, which is deemed to be
independent from the previous series.
By default, \code{jumps} = c(1,rep(0,n-1)) indicating the data is one Markov sequence.}

\item{MARGIN}{the marginal distribution function of the latent time series.
The default is the empirical cdf:
\deqn{\frac{1}{n+1}\sum_{t=1}^n I_{Y_t<=y}}.
 MARGIN can also be specified as
 other existing distribution functions such as pnorm.}

\item{...}{additional parameters for the marginal distribution of the latent time series.}

\item{interval}{the lower and upper bound for the copula paraameter.
By default,  \code{interval}=
c(-1,1) for Gaussian copula,
c(-1,Inf) for Clayton copula,
c(1,Inf) for Gumbel and Joe copula and
c(-Inf,Inf) for Frank copula.}
}
\value{
\code{estCopC} returns a list of components including.
\item{para}{the pseudo maximum likelihood estimator of the copula parameter.}
\item{likelihood}{the negative log-likelihood value corresponding to the estimated copula parameter.}
\item{copula}{the estimated copula object, with estimated copula parameter plugged in.}
}
\description{
Obtains the pseudo maximum likelihood estimator of the copula parameter based on censored time series.
}
\examples{
### Using a simulated data for demonstration:
set.seed(20)
Y = genLatentY(cop="Clayton",1,30,MARGIN.inv = qt,df=3)
d = -1
Yc = pmax(d,Y)
delta = (Y>d)
## CopC estimator
estCopC(cop = "Clayton",Yc,d,delta,nIS = 50,interval = c(1,10))
## Omniscient estimator
estCopC(cop = "Clayton",Y,d,delta=rep(TRUE,length(Y)),interval = c(1,10))
## CopC estimator under true marginal
estCopC(cop = "Clayton",Yc,d,delta,nIS = 50,MARGIN=pt,df=3,interval = c(1,10))
### Analyze the water quality data:
attach(water)
Yc = TNH3[1:30]
delta = Delta[1:30]
jumps = Indep[1:30]
set.seed(1)
estCopC(cop="Clayton",Yc=Yc,d=0.02,delta=delta,jumps=jumps,interval = c(1,10),nIS=50)
}
\references{
Li, F., Tang, Y. and Wang, H. (2018).
Copula-based Semiparametric Analysis for Time Series Data with Detection Limits, technical report.
}
