% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeeganPackelConcept.R
\name{drawDeeganPackelIndex}
\alias{drawDeeganPackelIndex}
\title{draw Deegan-Packel index for 3 or 4 players}
\usage{
drawDeeganPackelIndex(
  v,
  holdOn = FALSE,
  colour = NA,
  label = TRUE,
  name = "Deegan Packel Index"
)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawDeeganPackelIndex draws the Deegan-Packel index for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
drawDeeganPackelIndex(v) 
}
\references{
Deegan J. and  Packel E.W. (1978) "A new index of power for simple n-person games", Int. Journal of Game Theory 7(2), pp. 151--161

Holler M.J. and Illing G. (2006) "Einfuehrung in die Spieltheorie". 6th Edition (in German), Springer, pp. 323--324
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
