% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clReferenceTree}
\alias{clReferenceTree}
\title{Tree topology for matrix simulation}
\format{
A single phylogenetic tree saved as an object of class \code{phylo}.
}
\source{
Congreve & Lamsdell (2016).
}
\usage{
clReferenceTree
}
\description{
The tree topology used to generate the matrices in \code{\link{clMatrices}}
Congreve & Lamsdell (2016).
}
\examples{
  data(clReferenceTree)
  if (requireNamespace('ape', quietly = TRUE)) plot(clReferenceTree)

}
\references{
\itemize{
\item Congreve, C. R. & Lamsdell, J. C. (2016). Implied weighting and its
utility in palaeontological datasets: a study using modelled phylogenetic
matrices. \emph{Palaeontology} 59(3), 447--465. \doi{10.1111/pala.12236}.
\item Congreve, C. R. & Lamsdell, J. C. (2016). Data from: Implied weighting and its
utility in palaeontological datasets: a study using modelled phylogenetic
matrices. Dryad Digital Repository. \doi{10.5061/dryad.7dq0j}.
}
}
\keyword{datasets}
