% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMould_VTT.R
\name{calcMould_VTT}
\alias{calcMould_VTT}
\title{Calculate Mould Growth Index (VTT model)}
\usage{
calcMould_VTT(
  Temp,
  RH,
  M_prev = 0,
  sensitivity = "very",
  wood = 0,
  surface = 0
)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{M_prev}{The previous mould index value (default is 0).}

\item{sensitivity}{The sensitivity level of the material to mould growth. Options are 'very', 'sensitive', 'medium', or 'resistant'. Default is 'very'.}

\item{wood}{The wood species; 0 for pine and 1 for spruce. Default is 0.}

\item{surface}{The surface quality; 0 for resawn kiln dried timber and 1 for timber dried under normal kiln drying process. Default is 0 (worst case).}
}
\value{
M Mould growth index

\itemize{
  \item 0 = No mould growth
  \item 1 = Small amounts of mould growth on surface visible under microscope
  \item 2 = Several local mould growth colonies on surface visible under microscope
  \item 3 = Visual findings of mould on surface <10\% coverage or 50\% coverage under microsocpe
  \item 4 = Visual findings of mould on surface 10-50\% coverage or >50\% coverage under microscope
  \item 5 = Plenty of growth on surface >50\% visual coverage
  \item 6 = Heavy and tight growth, coverage almost 100\%
}
}
\description{
This function calculates the mould growth index on wooden materials based on temperature,
relative humidity, and other factors. It implements the mathematical model
developed by Hukka and Viitanen, which predicts mould growth under varying
environmental conditions.
}
\details{
Senstivity is related to the material surface, mould will grow on. Options in function avaiable are:

\itemize{
  \item 'very' sensitive materials include pine and sapwood.
  \item 'sensitive' materials include glued wooden boards, PUR with paper surface, spruce
  \item 'medium' resistant materials include concrete, glass wool, polyester wool
  \item 'resistant' materials include PUR polished surface
}
}
\examples{
# Mould growth index at 25°C (Temp) and 85\% relative humidity (RH)
calcMould_VTT(Temp = 25, RH = 85)

calcMould_VTT(Temp = 18, RH = 70, M_prev = 2, sensitivity = "medium", wood = 1, surface = 1)

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |>
   dplyr::mutate(
      MouldIndex = calcMould_VTT(Temp, RH),
      MouldIndex_sensitve = calcMould_VTT(Temp, RH, sensitivity = "sensitive")
   )



}
\references{
Hukka, A., Viitanen, H. A mathematical model of mould growth on wooden material. Wood Science and Technology 33, 475–485 (1999). https://doi.org/10.1007/s002260050131

Viitanen, Hannu, and Tuomo Ojanen. "Improved model to predict mold growth in building materials." Thermal Performance of the Exterior Envelopes of Whole Buildings X–Proceedings CD (2007): 2-7.
}
