% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_similarity.R
\name{consensus_similarity}
\alias{consensus_similarity}
\title{Consensus Similarity}
\usage{
consensus_similarity(comm_matrix)
}
\arguments{
\item{comm_matrix}{a matrix whose columns are different partition and whose
rows are nodes within a network}
}
\value{
the consensus partition determined by the maximum
average pairwise similarity
}
\description{
Description of the consensus similarity function.
}
\details{
This function identifies a single representative partition from a set of
partitions that is the most similar to the all others. Here, similarity is
taken to be the z-score of the Rand coefficient.
}
\examples{

set.seed(7183)
x <- sample(x = rep(1:3, 4), 12)

y <- sample(x = rep(1:3, 4), 12)

z <- sample(x = rep(1:3, 4), 12)

xyz_comms_mat <- matrix(c(x,y,z),nrow=length(x),ncol=3)
consensus_similarity(xyz_comms_mat)

}
