% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FS.R
\name{FS}
\alias{FS}
\title{FS: Fitzpatrick and Scott Method for Simultaneous Confidence Intervals}
\usage{
FS(inpmat, alpha)
}
\arguments{
\item{inpmat}{Integer vector of observed counts (non-negative values).}

\item{alpha}{Desired statistical Significance level.}
}
\value{
Prints the original and adjusted confidence intervals for each
category, as well as the overall interval volume.
}
\description{
Computes simultaneous confidence intervals for multinomial proportions
using the Fitzpatrick and Scott (FS) method. The function estimates the
lower and upper confidence limits for each category, adjusts them to
remain within the [0, 1] range, and calculates the overall volume
(product of interval widths).
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 0.05
FS(y, z)

}
