% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockCohortSymmetry.R
\name{mockCohortSymmetry}
\alias{mockCohortSymmetry}
\title{Creates mock cdm object for testing}
\usage{
mockCohortSymmetry(
  seed = 1,
  indexCohort = NULL,
  markerCohort = NULL,
  con = NULL,
  schema = "main"
)
}
\arguments{
\item{seed}{The seed to be inputted.}

\item{indexCohort}{The tibble of your index cohort.
Default is NULL, which means the default indexCohort is being used.}

\item{markerCohort}{The tibble of your marker cohort.
Default is NULL, which means the default markerCohort is being used.}

\item{con}{Connection detail.}

\item{schema}{Name of your write schema.}
}
\value{
A mock cdm object contains your index and marker cohort
}
\description{
Creates a mock cdm with two default synthetic cohorts,
one is the index cohort and the other one is the marker cohort.
However the users could specify them should they wish.
}
\examples{
\donttest{
library(CohortSymmetry)
cdm <- mockCohortSymmetry()
cdm
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
