% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireDemographics.R
\name{requireDemographics}
\alias{requireDemographics}
\title{Restrict cohort on patient demographics}
\usage{
requireDemographics(
  cohort,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  ageRange = list(c(0, 150)),
  sex = c("Both"),
  minPriorObservation = 0,
  minFutureObservation = 0,
  atFirst = FALSE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Variable in cohort that contains the date to compute the
demographics characteristics on which to restrict on.}

\item{ageRange}{A list of vectors specifying minimum and maximum age.}

\item{sex}{Can be "Both", "Male" or "Female".}

\item{minPriorObservation}{A minimum number of continuous prior observation
days in the database.}

\item{minFutureObservation}{A minimum number of continuous future observation
days in the database.}

\item{atFirst}{If FALSE the requirement will be applied to all records, if
TRUE, it will only be required for the first entry of each subject.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
The cohort table with only records for individuals satisfying the
demographic requirements
}
\description{
\code{requireDemographics()} filters cohort records, keeping only records where
individuals satisfy the specified demographic criteria.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()

cdm$cohort1 |>
  requireDemographics(indexDate = "cohort_start_date",
                      ageRange = list(c(18, 65)),
                      sex = "Female",
                      minPriorObservation = 365)
}
}
